from copy import copy

class Espace:
    """ Un espace de recherche dans lequel les éléments sont connectés par des arcs. """

    def __init__(self, elements=None, arcs=None):
        """
            :param list elements: une liste d'éléments.
            :param list arcs: une liste d'arcs sous forme de tuples\
            ``(element_1, element_2)``.
        """

        self.elements = []
        if elements is not None:
            self.elements = sorted(self.elements, key=lambda e: e.nom)

        self.arcs = []
        if arcs is not None:
            self.ajoute_arcs(arcs)

    def ajoute_arcs(self, arcs):
        """
            Ajoute des arcs à l'espace.
            
            Les éventuels éléments nouveaux mentionnés dans\
            les arcs seront aussi ajoutés à la liste d'éléments
            de l'espace.
            
            :param list arcs: une liste d'arcs.
        """
        for element_1, element_2 in arcs:
            if not element_1 in self.elements:
                self.elements.append(element_1)
            if not element_2 in self.elements:
                self.elements.append(element_2)

            if not (element_1, element_2) in self.arcs:
                self.arcs.append((element_1, element_2))

        self.elements = sorted(self.elements, key=lambda e: e.nom)

    def trouve_voisins(self, element):
        """
            :return: les voisins d'un élément.
        """
        voisins = []

        for element_1, element_2 in self.arcs:
            if element_1 == element:
                voisins.append(element_2)
            if element_2 == element:
                voisins.append(element_1)

        voisins = sorted(voisins, key=lambda v: v.nom)

        return voisins

    def __repr__(self):
        rep = ''
        for element in self.elements:
            rep += '{}, '.format(element)
            rep += 'avec voisins: '
            voisins = self.trouve_voisins(element)
            rep += ', '.join(map(str, voisins))
            rep +='\n'

        return rep