from .element import Element

class Cellule(Element):
    """ Un élément représentant une cellule dans un labyrinthe. """

    def __init__(self, ligne, colonne, libre, nom=''):
        """
            :param ligne: la ligne de la cellule.
            :param colonne: la colonne de la cellule.
            :param libre: indique si la cellule est libre.
            :param str nom: le nom de la cellule.
        """

        Element.__init__(self, nom)
        self.ligne = ligne
        self.colonne = colonne
        self.libre = libre

    def est_libre(self):
        return self.libre

    def distance(self, cellule):
        """ Distance de Manhattan entre la cellule courante et la cellule\
            ``cellule ``.
        """

        return abs(self.ligne-cellule.ligne) + abs(self.colonne-cellule.colonne)

    def __eq__(self, autre):
        return self.ligne == autre.ligne and self.colonne == autre.colonne

    def __hash__(self):
        return hash(str(self))

    def __repr__(self):
        return '({}, {})'.format(self.ligne, self.colonne)