from moteurs_recherche.recherche import Recherche
from moteurs_recherche.noeud import Noeud

class RechercheAStar(Recherche):
    """ Recherche de chemin avec A\*. """

    def detecte_cycle(self, trace, noeud):
        if noeud.element not in trace:
            return False

        autre = trace[noeud.element]
        return autre.cout_f <= noeud.cout_f

    def ajoute_successeurs(self, queue, successeurs):
        queue = queue + successeurs
        queue = sorted(queue, key=lambda n: n.cout_f)

        return queue