from moteurs_recherche.element import Element
from moteurs_recherche.cellule import Cellule
from moteurs_recherche.espace import Espace
from moteurs_recherche.dfs import RechercheDFS
from moteurs_recherche.bfs import RechercheBFS
from moteurs_recherche.astar import RechercheAStar

labyrinthe = [['.', '.', '.', 'x'],
              ['.', 'x', '.', '.'],
              ['.', '.', '.', 'x'],
             ]

lignes = len(labyrinthe)
colonnes = len(labyrinthe[0])

# Les éléments (les cellules dans le labyrinthe). 
elements = []
for ligne in range(lignes):
    elements_ligne = []
    for colonne in range(colonnes):
        nom = '{}-{}'.format(ligne, colonne)
        libre = labyrinthe[ligne][colonne] != 'x'
        cellule = Cellule(ligne, colonne, libre, nom)
        elements_ligne.append(cellule)
    elements.append(elements_ligne)

# Les arcs connectant les éléments.
arcs = []
for ligne in range(lignes):
    for colonne in range(colonnes):
        if elements[ligne][colonne].est_libre():
            if colonne < colonnes-1 and elements[ligne][colonne+1].est_libre():
                arcs.append((elements[ligne][colonne], 
                             elements[ligne][colonne+1]))
            if ligne < lignes-1 and elements[ligne+1][colonne].est_libre():
                arcs.append((elements[ligne][colonne], 
                             elements[ligne+1][colonne]))

espace = Espace(sum(elements, []), arcs)
print('L\'espace de recherche:\n{}'.format(espace))

print('Recherche DFS:')
dfs = RechercheDFS(espace, True)
chemin = dfs.recherche(elements[0][0], elements[1][3])

print('Chemin: {}'.format(chemin))

#################################################

print('\nRecherche BFS:')
bfs = RechercheBFS(espace, True)

chemin = bfs.recherche(elements[0][0], elements[1][3])
print('Chemin: {}'.format(chemin))

#################################################

print('\nRecherche A*:')
astar = RechercheAStar(espace, True)
chemin = astar.recherche(elements[0][0], elements[1][3])

print('Chemin: {}'.format(chemin))