from moteurs_recherche.element import Element
from moteurs_recherche.ville import Ville
from moteurs_recherche.espace import Espace
from moteurs_recherche.dfs import RechercheDFS
from moteurs_recherche.bfs import RechercheBFS
from moteurs_recherche.astar import RechercheAStar

# Les éléments dans l'espace de recherche (les villes).
elements = {
    'Lausanne': Ville(110, 260, 'Lausanne'),
    'Genève': Ville(40, 300, 'Genève'),
    'Sion': Ville(200, 300, 'Sion'),
    'Neuchâtel': Ville(150, 170, 'Neuchâtel'),
    'Bern': Ville(210, 280, 'Bern'),
    'Basel': Ville(230, 65, 'Basel'),
    'Fribourg': Ville(175, 200, 'Fribourg'),
    'Zürich': Ville(340, 90, 'Zürich'),
    'Aarau': Ville(290, 95, 'Aarau'),
    'Luzern': Ville(320, 155, 'Luzern'),
    'St-Gallen': Ville(85, 455,  'St-Gallen'),
    'Thun': Ville(235, 210, 'Thun'),
}

# Les arcs liant les éléments (les routes).
arcs = [
    (elements['Lausanne'], elements['Genève']),
    (elements['Sion'], elements['Lausanne']),
    (elements['Neuchâtel'], elements['Lausanne']),
    (elements['Fribourg'], elements['Lausanne']),
    (elements['Fribourg'], elements['Bern']),
    (elements['Sion'], elements['Thun']),
    (elements['Neuchâtel'], elements['Bern']),
    (elements['Basel'], elements['Bern']),
    (elements['Zürich'], elements['Aarau']),
    (elements['Zürich'], elements['Luzern']),
    (elements['Bern'], elements['Aarau']),
    (elements['Bern'], elements['Luzern']),
    (elements['Luzern'], elements['Aarau']),
    (elements['St-Gallen'], elements['Zürich']),
    (elements['Thun'], elements['Bern']),
    (elements['Basel'], elements['Zürich']),
]

# L'espace de recherche.
espace = Espace(elements.values(), arcs)
print('L\'espace de recherche:\n{}'.format(espace))

print('Recherche DFS:')
dfs = RechercheDFS(espace, False)
chemin = dfs.recherche(elements['Lausanne'], elements['Zürich'])

print('Chemin: {}'.format(chemin))

#################################################

print('\nRecherche BFS:')
bfs = RechercheBFS(espace, False)
chemin = bfs.recherche(elements['Lausanne'], elements['Zürich'])

print('Chemin: {}'.format(chemin))

#################################################

print('\nRecherche A*:')
astar = RechercheAStar(espace, False)
chemin = astar.recherche(elements['Lausanne'], elements['Zürich'])

print('Chemin: {}'.format(chemin))