from moteurs_recherche.element import Element
from moteurs_recherche.ville import Ville
from moteurs_recherche.espace import Espace
from moteurs_recherche.dfs import RechercheDFS
from moteurs_recherche.bfs import RechercheBFS
from moteurs_recherche.astar import RechercheAStar

# Les éléments dans l'espace de recherche (les villes).
elements = {
    'A': Ville(0, 16, 'A'),
    'B': Ville(5, 13, 'B'),
    'C': Ville(0, 10, 'C'),
    'D': Ville(5, 8, 'D'),
    'E': Ville(11, 18, 'E'),
    'F': Ville(15, 13, 'F'),
    'G': Ville(29, 18, 'G'),
    'H': Ville(26, 0, 'H'),
    'I': Ville(12, 10, 'I'),
    'J': Ville(17, 7, 'J'),
    'K': Ville(11, 3, 'K'),
    'L': Ville(22, 16, 'L'),
    'M': Ville(25, 12, 'M'),
    'N': Ville(24, 6, 'N'),
    'O': Ville(20, 0, 'O'),
    'P': Ville(5, 0, 'P'),
}

# Les arcs liant les éléments (les routes).
arcs = [
    (elements['A'], elements['B']),
    (elements['A'], elements['E']),
    (elements['B'], elements['C']),
    (elements['B'], elements['E']),
    (elements['B'], elements['D']),
    (elements['C'], elements['D']),
    (elements['C'], elements['P']),
    (elements['D'], elements['I']),
    (elements['D'], elements['K']),
    (elements['E'], elements['F']),
    (elements['E'], elements['L']),
    (elements['F'], elements['I']),
    (elements['F'], elements['L']),
    (elements['F'], elements['M']),
    (elements['G'], elements['H']),
    (elements['G'], elements['L']),
    (elements['G'], elements['M']),
    (elements['I'], elements['J']),
    (elements['J'], elements['K']),
    (elements['J'], elements['N']),
    (elements['K'], elements['O']),
    (elements['K'], elements['P']),
    (elements['M'], elements['N']),
    (elements['N'], elements['O']),
    (elements['B'], elements['I']),
    (elements['B'], elements['F']),
    (elements['P'], elements['O'])
]

# L'espace de recherche.
espace = Espace(elements.values(), arcs)
print('L\'espace de recherche:\n{}'.format(espace))

print('Recherche DFS:')
dfs = RechercheDFS(espace, False)
chemin = dfs.recherche(elements['A'], elements['P'])

print('Chemin: {}'.format(chemin))

#################################################

print('\nRecherche BFS:')
bfs = RechercheBFS(espace, False)

chemin = bfs.recherche(elements['A'], elements['P'])
print('Chemin: {}'.format(chemin))

#################################################

print('\nRecherche A*:')
astar = RechercheAStar(espace, False)
chemin = astar.recherche(elements['A'], elements['P'])

print('Chemin: {}'.format(chemin))