from unittest import TestCase
from moteur_avec_variables.unificateur import Unificateur

class Testunificateur(TestCase):

    def test_unifie_simple(self):
        prop1 = ('?x', 'is', '?y')
        prop2 = ('The night', 'is', 'dark')
        unificateur = Unificateur()

        self.assertEqual(unificateur.unifie(prop2, prop1), {'?x': 'The night', '?y': 'dark'})

        self.assertEqual(unificateur.unifie(('?x', 'est un', 'doctorant'),
                                            ('Vincent', 'est un', 'doctorant')),
                                            {'?x': 'Vincent'})
        self.assertEqual(unificateur.unifie(('Vincent', 'est un', 'doctorant'),
                                            ('?x', 'est un', 'doctorant')),
                                            {'?x': 'Vincent'})
        self.assertEqual(unificateur.unifie(('Vincent', 'est un', 'doctorant'),
                                            ('Vincent', 'est un', 'doctorant')),
                                            {})
        self.assertEqual(unificateur.unifie(('Vincent', 'est un', '?y'),
                                            ('?x', 'est un', 'doctorant')),
                                            {'?x': 'Vincent',
                                             '?y': 'doctorant'})

        self.assertEqual(unificateur.unifie(('Vincent', 'est un', 'doctorant'),
                                            ('Michel', 'est un', 'doctorant')),
                        Unificateur.echec)


    def test_unifie_nested(self):
        prop1 = ('foo', 'Jean', ('Marc', 'bar', 'Paul'))
        prop2 = ('foo', '?x', ('?y', 'bar', '?z'))
        unificateur = Unificateur()

        self.assertEqual(unificateur.unifie(prop1, prop2), {'?x': 'Jean',
                                                            '?y': 'Marc',
                                                            '?z': 'Paul'})

        self.assertEqual(unificateur.unifie(('foo', '?x', ('?y', 'bar', 'Jean')),
                                            ('foo', 'Jean', ('Marc', 'bar', '?z'))),
                                            {'?x': 'Jean',
                                             '?y': 'Marc',
                                             '?z': 'Jean'})

        self.assertEqual(unificateur.unifie(('foo', '?x', ('?y', 'bar', 'Jean')),
                                            ('foo', 'Jean', ('Marc', 'bar', '?x'))),
                                            {'?x': 'Jean',
                                             '?y': 'Marc'})
        self.assertEqual(unificateur.unifie(('foo', '?x', ('?y', 'bar', 'Marc')),
                                            ('foo', 'Jean', ('Marc', 'bar', '?x'))),
                        Unificateur.echec)

        self.assertEqual(unificateur.unifie(('p', '?x', ('f', '?y')),
                                            ('p', ('f', 'a'), '?x')),
                                            {'?x': ('f', 'a'), '?y': 'a'})

    def test_unifie_variables_deux_cotes(self):
        prop1 = ('Vincent', 'est un', '?x')
        prop2 = ('?x', 'est un', 'Vincent') 
        unificateur = Unificateur()
        self.assertEqual(unificateur.unifie(prop1, prop2), {'?x': 'Vincent'})

    def test_unifie_unmatchable(self):
        prop1 = ('?x', 'is', '?x')
        prop2 = ('The night', 'is', 'dark')
        unificateur = Unificateur()
        self.assertEqual(unificateur.unifie(prop2, prop1), Unificateur.echec)

    def test_unifie_prop2_too_short(self):
        prop1 = ('?x', 'is', '?y')
        prop2 = ('The night', 'is')
        unificateur = Unificateur()
        self.assertEqual(unificateur.unifie(prop2, prop1), Unificateur.echec)