/**************************************************************/
/*                                                            */
/*                        Classe TOWN                         */
/*                                                            */
/**************************************************************/


import java.util.*;


/**
* Classe Town :
* Ville (sommet) d'un graphe.
* Utilisee pour l'exercice de recherche de chemins dans un graphe.
*
* @version 	1.0, 1 Avr 1997
* @author Bruno Sakoto
**/

public class Town
{
	protected String name;
	protected int coordX;
	protected int coordY;
	protected Vector vNeighbor;
	protected int heuristic;
	
	
	
	/**************************************************************/
	/* Methode TOWN                                               */
	/**************************************************************/
	/**
	* Cree une ville vide.
	**/
	 
	public Town()
	{
		name = new String();
		coordX = -1;
		coordY = -1;
		vNeighbor = new Vector();
		heuristic = -1;
	}



	/**************************************************************/
	/* Methode TOWN                                               */
	/**************************************************************/
	/**
	* Cree une ville particuliere.
	* @param nom le nom de la ville.
	* @param cX l'abcisse de la ville.
	* @param cY l'ordonnee de la ville. 
	**/

	public Town( String nom, int cX, int cY )
	{
		name = nom;
		coordX = cX;
		coordY = cY;
		vNeighbor = new Vector(); 
		heuristic = -1;	
	}
	


	/**************************************************************/
	/* Methode COPY                                               */
	/**************************************************************/
	/**
	* Cree une copie de la ville. 
	**/

	public Town Copy()
	{
		Town town = new Town();
		
		town.name = name;
		town.coordX = coordX;
		town.coordY = coordY;
		town.vNeighbor = vNeighbor; 
		town.heuristic = heuristic;
		
		return town;	
	}
	
	
	
	/**************************************************************/
	/* Methode PRINT                                              */
	/**************************************************************/
	/**
	* Affiche les proprietes de la ville.
	**/
	
	public void Print()
	{		
		System.out.println( "Ville : " + name );
		
		System.out.println( "X = " + coordX + ", Y = " + coordY );
		
		System.out.println( "Valeur heuristique : " + heuristic );
		
		System.out.print( "Voisins : " );
		Enumeration enum = vNeighbor.elements();
		while ( enum.hasMoreElements() )
			System.out.print( ((Town)enum.nextElement()).name + " " );
		System.out.println( "\n" );
	
	}



	/**************************************************************/
	/* Methode ADD_ROAD                                           */
	/**************************************************************/
	/**
	* Ajoute une route directe entre la ville et une autre ville.
	* @param ville la ville que l'on peut relier directement. 
	**/
	
	public void AddRoad( Town ville )
	{
		vNeighbor.addElement( ville );
	}



	/**************************************************************/
	/* Methode STRAIGHT_LINE_DISTANCE                             */
	/**************************************************************/
	/**
	* Calcule la distance qui separe la ville d'une autre ville
	* en utilisant les coordonees des villes.
	* @param ville la ville avec laquelle on veut calculer la distance.
	* @return la valeur trouvee.
	**/

	public int StraightLineDistance( Town ville )
	{
		int x1 = coordX;
		int y1 = coordY;
		int x2 = ville.coordX;
		int y2 = ville.coordY;
		
		double d = Math.pow( Math.abs( x2 - x1 ), 2 ) + Math.pow( Math.abs( y2 - y1 ), 2 );
		d = Math.sqrt( d );

		return Math.round( (float)d );
	}
	
	
	
}