/**************************************************************/
/*                                                            */
/*                   Classe SEARCH_APPLET                     */
/*                                                            */
/**************************************************************/


import java.applet.*;
import java.awt.*;


/**
* Classe SearchApplet :
* Applet pour l'exercice de recherche dans un graphe.
*
* @version 	1.0, 1 Avr 1997
* @author Bruno Sakoto
**/

public class SearchApplet extends Applet implements Runnable
{
	protected GraphCanvas dessin;
	protected ControlPanel control;
	protected ResultPanel result;
	
	protected Thread anim = null; 

	protected static Work work;       // L'espace de travail.
	


	/**************************************************************/
	/* Methode INIT                                               */
	/**************************************************************/
	/**
	* Initialisation de l'applet.
	**/
	
	public void init()
	{
		GridBagLayout gridbag = new GridBagLayout();
		setLayout( gridbag );
	
		// Initialisation de l'espace de travail et de son graphe.	
		work = new Work();
		work.graph.InitTowns();
		work.graph.InitRoads();
		work.graph.InitPaths();
		work.graph.CreateNeighborsOfTowns();
		work.graph.PutDefaultCosts();
		work.graph.PutDefaultHeuristics( ((Town)work.graph.vTown.elementAt( 7 )).name );
		
		// Mise en place du dessin du graphe.
		dessin = new GraphCanvas();
		Constrain.constrain( this, dessin, 0, 0, 1, 1 );
		dessin.resize( 528, 408 );  //400x300
		
		// Mise en place du panneau de controle.
		control = new ControlPanel();
		Constrain.constrain( this, control, 1, 0, 1, 1 );
		
		// Mise en place du panneau de resultat.
		result = new ResultPanel();
		Constrain.constrain( this, result, 0, 1, 2, 1 );
		
	}



	
	/**************************************************************/
	/* Methode START                                              */
	/**************************************************************/
	/**
	* Demmarrage de l'applet.
	**/

	public void start()
	{
		if ( anim == null )
		{
//			anim = new Thread( this );
//			anim.start();
		}
	}


	
	
	/**************************************************************/
	/* Methode STOP                                              */
	/**************************************************************/
	/**
	* Interruption de l'applet.
	**/

	public void stop()
	{
		if ( anim != null )
			anim.stop();
		anim = null;
	}
	
	
	
	/**************************************************************/
	/* Methode RUN                                                */
	/**************************************************************/
	/**
	* Executee lorsque l'applet demmarre.
	**/

	public void run()
	{
		while ( true )
		{
			try { Thread.sleep( 1000 ); }
			catch ( InterruptedException e ){};
		}
	}
	

}