/**************************************************************/
/*                                                            */
/*                        Classe ROAD                         */
/*                                                            */
/**************************************************************/


import java.util.*;


/**
* Classe Road :
* Route (arete) d'un graphe.
* Utilisee pour l'exercice de recherche de chemins dans un graphe.
*
* @version 	1.0, 1 Avr 1997
* @author Bruno Sakoto
**/

public class Road
{
	protected Town origine;
	protected Town extremite;
	protected int cost;
	
	
		
	/**************************************************************/
	/* Methode ROAD                                               */
	/**************************************************************/
	/**
	* Cree une route vide. 
	**/
	 
	public Road()
	{
		origine = new Town();
		extremite = new Town();
		cost = -1;
	}



	/**************************************************************/
	/* Methode ROAD                                               */
	/**************************************************************/
	/**
	* Cree une route particuliere. 
	**/

	public Road( Town ville1, Town ville2 )
	{
		origine = ville1;
		extremite = ville2;
		cost = -1;
	}
	


	/**************************************************************/
	/* Methode COPY                                               */
	/**************************************************************/
	/**
	* Cree une copie de la route. 
	**/

	public Road Copy()
	{
		Road route = new Road();
		
		route.origine = origine;
		route.extremite = extremite;
		route.cost = cost;
		
		return route;	
	}
	
	
	
	
	/**************************************************************/
	/* Methode PRINT                                              */
	/**************************************************************/
	/**
	* Affiche les proprietes de la route.
	**/
	
	public void Print()
	{		
		System.out.println( "Route : " + origine.name + " - " + extremite.name );
		System.out.println( "Cout = " + cost );
		System.out.println( "\n" );
	}




	/**************************************************************/
	/* Methode STRAIGHT_LINE_DISTANCE                             */
	/**************************************************************/
	/**
	* Calcule la longueur de la route. 
	* @return la longueur trouvee.
	**/

	public int StraightLineDistance()
	{
		return origine.StraightLineDistance( extremite );
	}
	
	
}