/**************************************************************/
/*                                                            */
/*                   Classe RESULT_PANEL                      */
/*                                                            */
/**************************************************************/


import java.awt.*;
import java.util.*;


/**
* Classe ResultPanel :
* Permet de realiser le panneau de resultat.
* Utilisee pour l'exercice de recherche de chemins dans un graphe.
*
* @version 	1.0, 1 Avr 1997
* @author Bruno Sakoto
**/

public class ResultPanel extends Panel
{
	protected TextArea detailsTextArea;
	protected Button nextButton;
	protected Button endButton;
	
	protected StringTokenizer strTok = null;     // Chaine permettant de placer le detail
	                                             // de la recherche pas a pas.
	


	/**************************************************************/
	/* Methode RESULT_PANEL                                       */
	/**************************************************************/
	/**
	* Construit un panneau de resultat avec ses differents composants.
	**/

	public ResultPanel()
	{
		// Fixer le Layout.
		GridBagLayout gridbag = new GridBagLayout();		
		setLayout( gridbag );

		// Details de la recherche.
		Constrain.constrain( this, new Label( "Details of the search :" ), 0, 0, 1, 1,
		                     15, 15, 0, 0 );
		detailsTextArea = new TextArea( 4, 50 );
		detailsTextArea.setFont( new Font( "Courrier", Font.PLAIN, 12 ) );
		detailsTextArea.setEditable( false );
		Constrain.constrain( this, detailsTextArea, 0, 1, 1, 1 );
		
		// Bouton next.
		nextButton = new Button( "Next step" );
		Constrain.constrain( this, nextButton, 1, 1, 1, 1, 0, 15, 0, 0 );
		nextButton.disable();
		
		// Bouton end.
		endButton = new Button( "Finish" );
		Constrain.constrain( this, endButton, 2, 1, 1, 1, 0, 15, 0, 0 );
		endButton.disable();
		

	}
	



	/**************************************************************/
	/* Methode ACTION                                             */
	/**************************************************************/
	/**
	* Apellee si une action intervient dans le paneau de controle.
	**/
	
	public boolean action( Event evt, Object arg )
	{
		if ( evt.target == nextButton )
		{
			// NEXT_BUTTON
			
			// L'utilisateur veut voir l'etape suivante de la recherche.
			
			detailsTextArea.appendText( strTok.nextToken() );
			detailsTextArea.appendText( "\n" );
		
			if ( ! strTok.hasMoreElements() )
			{
				// La derniere etape vient d'etre affichee.
			
				// Redessiner le graphe avec le chemin.
				((SearchApplet)getParent()).dessin.showPath = true;
				((SearchApplet)getParent()).dessin.repaint();
			
				// Desactiver les boutons d'execution pas a pas.
				nextButton.disable();
				endButton.disable();
				
				// Reactiver le panneau de controle.
				((SearchApplet)getParent()).control.enable();
				((SearchApplet)getParent()).control.okButton.enable();

			}
		
			return true;
		}
		
		
		if ( evt.target == endButton )
		{
			// END_BUTTON
			
			// L'utilisateur veut terminer la recherche.
			
			while ( strTok.hasMoreTokens() )
			{
				detailsTextArea.appendText( strTok.nextToken() );
				detailsTextArea.appendText( "\n" );
			}

			// Redessiner le graphe avec le chemin.
			((SearchApplet)getParent()).dessin.showPath = true;
			((SearchApplet)getParent()).dessin.repaint();
			
			// Desactiver les boutons d'execution pas a pas	.
			nextButton.disable();
			endButton.disable();
			
			// Reactiver le panneau de controle.
			((SearchApplet)getParent()).control.enable();
			((SearchApplet)getParent()).control.okButton.enable();
		
			return true;
		}
		
		
		return false;	
 
	}




	/**************************************************************/
	/* Methode INIT_DETAILS                                       */
	/**************************************************************/
	/**
	* Initialise la zone de details de la recherche avec une chaine
	* vide.
	**/
	
	public void InitDetails()
	{
		detailsTextArea.setText( "" );
	}




	/**************************************************************/
	/* Methode SET_DETAILS                                        */
	/**************************************************************/
	/**
	* Place une chaine dans la zone de details de la recherche.
	* @param str la chaine a placer.
	**/
	
	public void SetDetails( String str )
	{
		detailsTextArea.setText( str );
		detailsTextArea.appendText( "" );
	}

	
}