/**************************************************************/
/*                                                            */
/*                         Classe NODE                        */
/*                                                            */
/**************************************************************/


import java.util.*;


/**
* Classe Node :
* Noeud de recherche dans un graphe.
* Utilisee pour l'exercice de recherche de chemins dans un graphe.
*
* @version 	1.0, 1 Avr 1997
* @author Bruno Sakoto
**/

public class Node
{
	protected Town description;
	protected int cost;             // Cout pour venir du noeud de depart.
	protected int finalCost;        // Estimation du cout final.
	protected Node ancestor;	
	
	
	
	/**************************************************************/
	/* Methode NODE                                               */
	/**************************************************************/
	/**
	* Cree un noeud de recherche vide. 
	**/
	 
	public Node()
	{
		description = new Town();
		cost = -1;
		finalCost = -1;
		ancestor = null;
	}




	/**************************************************************/
	/* Methode PRINT                                              */
	/**************************************************************/
	/**
	* Affiche les proprietes du noeud.
	**/
	
	public void Print()
	{		
		System.out.println( "Noeud de recherche : " + description.name );
		System.out.println( "Cout = " + cost + " Cout final estime = " + finalCost );
		System.out.println( "Parent : " + ancestor.description.name );			
	}




	/**************************************************************/
	/* Methode SUCCESSORS                                         */
	/**************************************************************/
	/**
	* Determine les successeurs du noeud de recherche.
	* Met a jour le champ ancestor et le champ cost (si la methode 
	* de recherche est A*).
	* @param villeDest la ville de destination recherchee.
	* @param methode l'algorithme de recheche utilisee.
	* @return un vecteur contenant les noeuds successeurs trouves.
	**/
	
	public Vector Successors( Town villeDest, String methode )
	{
		Vector vRes = new Vector();
		
		// Parcourir les villes voisines de la ville courante
		Enumeration enumV = description.vNeighbor.elements();
		while ( enumV.hasMoreElements() )
		{
			Town ville = (Town)enumV.nextElement();
			
			Node newNode = new Node();
			newNode.description = ville;
			newNode.ancestor = this;
			
			// Calculer le cout pour atteindre le nouveau noeud.
		
			int oldCost;
			if ( newNode.ancestor != null )
				oldCost = newNode.ancestor.cost;
			else
				oldCost = 0;
				
			Road rte = SearchApplet.work.graph.FindRoad( newNode.ancestor.description, 
			                                             newNode.description );
			newNode.cost = oldCost + rte.cost;
		
			// Si la methode est A-star alors estimer le cout final de la recherche.
			if ( methode.equals( Work.A_STAR ) )
				newNode.finalCost = newNode.cost + ville.heuristic;
		
				
			vRes.addElement( newNode );
		}
		
		return vRes;
	
	}

	
	
	
	/**************************************************************/
	/* Methode IS_SOLUTION                                        */
	/**************************************************************/
	/**
	* Teste si le noeud de recherche est une solution.
	* @param ville la ville de destination souahitee.
	* @return vrai ou faux.
	**/
	
	public boolean IsSolution( Town ville )
	{
		return description.name.equals( ville.name );
	}
	
	
}