/**************************************************************/
/*                                                            */
/*                 Classe HEURISTIC_WINDOW                    */
/*                                                            */
/**************************************************************/


import java.awt.*;
import java.util.*;


/**
* Classe HeuristicWindow :
* Fenetre de gestion des valeurs des heuristiques en chaque sommet
* du graphe.
* Utilisee pour l'exercice de recherche de chemins dans un graphe.
*
* @version 	1.0, 1 Avr 1997
* @author Bruno Sakoto
**/

public class HeuristicWindow extends Frame
{
	protected TextField villeTF[];
	protected TextField heuristicTF[];
	protected Button defaultButton;
	protected Button cancelButton;
	protected Button okButton;
	
	protected AlertDialog dialog;

	protected Vector vTown;    	 // Vecteur des villes du graphe (sommets).
	protected Vector vTownTmp;	 // Copie de travail du vecteur des villes. 
	protected Town arrTown;    
	
	protected Component caller;
	
	

	/**************************************************************/
	/* Methode HEURISTIC_WINDOW                                   */
	/**************************************************************/

	public HeuristicWindow( Component caller, Vector vect, Town ville )
	{
		super( "Heuritics" );
	
		// Initialisation des proprietes
		this.caller = caller;
		vTown = vect;
		
		vTownTmp = new Vector();
		Enumeration enum = vTown.elements();
		while ( enum.hasMoreElements() )
			vTownTmp.addElement( ((Town)enum.nextElement()).Copy() );
			
		arrTown = ville;
		villeTF = new TextField[ vTown.size() ];
		heuristicTF = new TextField[ vTown.size() ];
		
		
		for ( int i=0; i<vTown.size(); i++ )
		{
			villeTF[i] = new TextField( ((Town)vTown.elementAt(i)).name, 4 );
			villeTF[i].setEditable( false );
			Integer val = new Integer( ((Town)vTown.elementAt(i)).heuristic );
			heuristicTF[i] = new TextField( val.toString(), 4 );
		}
		
		
		// Mise en place des noms de sommets et des heuristiques.
		
		GridBagLayout gridbag = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		
		setLayout( gridbag );
		
		int mid = vTown.size()/2;
	
		for ( int i=0; i<mid; i++ )
		{
			Constrain.constrain( this, villeTF[i], 0, i, 1, 1 );		
			Constrain.constrain( this, heuristicTF[i], 1, i, 1, 1, 0, 0, 0, 10 );
		}
		
		for ( int i=mid; i<vTown.size(); i++ )
		{
			Constrain.constrain( this, villeTF[i], 2, i-mid, 1, 1, 0, 10, 0, 0 );		
			Constrain.constrain( this, heuristicTF[i], 3, i-mid, 1, 1 );
		}
		

		// Mise en place du bouton des valeurs par defaut
		defaultButton = new Button( "Default values" );
		Constrain.constrain( this, defaultButton, 1, mid, 2, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 15, 0, 0, 0 );

		// Mise en place du bouton d'annulation
		cancelButton = new Button( "Cancel" );
		Constrain.constrain( this, cancelButton, 0, mid+1, 2, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 15, 0, 0, 15 );
		
		// Mise en place du bouton de validation
		okButton = new Button( "Enter" );
		Constrain.constrain( this, okButton, 2, mid+1, 2, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 15, 15, 0, 0 );

		// Deplacer et dimensionner la fenetre
		move( 500, 150 );
		pack();
		resize( size().width+60, size().height+60 );
		setResizable( false );
			
		show();
	}

	
	
	
	/**************************************************************/
	/* Methode SET_HEURISTICS_VAL                                 */
	/**************************************************************/
	/**
	* Permet de placer les valeurs des heuristiques dans les TextFields.
	* Les valeurs contenues dans vTownTmp sont utilisees.
	**/

	public void SetHeuristicsVal()
	{
		for ( int i=0; i<vTownTmp.size(); i++ )
		{
			Integer val = new Integer( ((Town)vTownTmp.elementAt(i)).heuristic );
			heuristicTF[i].setText( val.toString() );
		}
	}
	
	
	
	
	/**************************************************************/
	/* Methode SAVE_HEURISTICS_VAL                                */
	/**************************************************************/
	/**
	* Permet de sauver les valeurs des heuristiques des TextFields
	* dans les heuristiques des villes du graphe.
	* @return vrai si la mise a jour a pu avoir lieu.
	**/

	public boolean SaveHeuristicsVal()
	{
		// Verifier que les valeurs sont des entiers.
		for ( int i=0; i<vTownTmp.size(); i++ )
		{
			try
			{	
				Integer val = new Integer( heuristicTF[i].getText() );
			}
			catch ( NumberFormatException e )  
			{
				String str = new String( "Wrong value for the heuristic of the vertex " +
				                         ((Town)vTown.elementAt( i )).name + " ."); 
				dialog = new AlertDialog( this, str );
				dialog.move( 300, 300 );
				dialog.show();
			
				return false;
			}
			
		}
		
		// Effectuer la mise a jour.
		for ( int i=0; i<vTownTmp.size(); i++ )
		{
			Integer val = new Integer( heuristicTF[i].getText() );
			((Town)vTown.elementAt( i )).heuristic = val.intValue();
		}
		
		return true;
	}

	
	

	/**************************************************************/
	/* Methode ACTION                                             */
	/**************************************************************/
	/**
	* Apellee si une action intervient dans le paneau de controle.
	**/
	
	public boolean action( Event evt, Object arg )
	{
	
		if ( evt.target == defaultButton )
		{
			// DEFAULT BUTTON
		
			// Calculer les valeurs par defaut des heuristiques (dans vTownTmp)
			Enumeration enum = vTownTmp.elements();
			while ( enum.hasMoreElements() )
			{
				Town ville = (Town)enum.nextElement();
				ville.heuristic = ville.StraightLineDistance( arrTown );
			}
			
			// Placer les nouvelles valeurs dans les TextFields
			SetHeuristicsVal();
			
			return true;
		}
	
	
		if ( evt.target == cancelButton )
		{
			// CANCEL BUTTON
			caller.enable();
			dispose();
			return true;
		}

	
		if ( evt.target == okButton )
		{
			// OK BUTTON 
			if ( SaveHeuristicsVal() )
			{	
				((SearchApplet)caller).dessin.repaint();
				caller.enable();
				dispose();
			}
			return true;
		}
		
		return false;
	}

}