/**************************************************************/
/*                                                            */
/*                     Classe GRAPH_CANVAS                    */
/*                                                            */
/**************************************************************/


import java.awt.*;


/**
* Classe GraphCanvas :
* Canvas pour le dessin d'un graphe.
* Utilisee pour l'exercice de recherche de chemins dans un graphe.
*
* @version 	1.0, 1 Avr 1997
* @author Bruno Sakoto
**/

public class GraphCanvas extends Canvas
{

	// Definition des couleurs utilisees	
	protected static final Color COLOR_BG = Color.white;
	protected static final Color COLOR_BORDER = Color.black;
	protected static final Color COLOR_FONT_NAME = Color.black;
	protected static final Color COLOR_FONT_VALUE = Color.blue;	
	protected static final Color COLOR_VERTEX = Color.lightGray;
	protected static final Color COLOR_EDGE = Color.darkGray;
	protected static final Color COLOR_PATH = Color.red;

	// Definition de la largeur et de la hauteur des sommets
	protected static final int W_VERTEX = 40;
	protected static final int H_VERTEX = 30;
	
	// Definition du decalage pour ecrire le nom des sommets
	protected static final int DX = -4;
	protected static final int DY = 0;

	// Definition de la police
	protected static final Font FONT_NAME = new Font( "Courier", Font.PLAIN, 14 );
	protected static final Font FONT_VALUE = new Font( "Courier", Font.PLAIN, 12 );


	protected boolean showPath = false;	       // Booleen pour indiquer s'il faut representer
	                                           // le chemin.
	protected boolean showGraphValues = false; // Booleen pour indiquer s'il faut placer les 
	                                           // les couts et les heuristiques sur le graphe.                                       
	                                    



	/**************************************************************/
	/* Methode GRAPH_CANVAS                                       */
	/**************************************************************/
		
	public GraphCanvas()
	{
	}




	/**************************************************************/
	/* Methode PAINT                                              */
	/**************************************************************/
	/**
	* Dessinne le graphe.
	**/
	
	public void paint( Graphics g )
	{		
		Graph graph = SearchApplet.work.graph;		


		// Colorier le fond et tracer le cadre
		g.setColor( COLOR_BG );
		g.fillRect( 0, 0, size().width-1, size().height-1 );
		g.setColor( COLOR_BORDER );
		g.drawRect( 0, 0, size().width-1, size().height-1 );
		
		
		// Dessiner les aretes
		for ( int i=0; i<graph.vRoad.size(); i++ )
		{	
			Road route = ((Road)graph.vRoad.elementAt( i ));
			Town origine =  route.origine;
			Town extremite = route.extremite;
			
			if ( showPath && graph.aPath[i] )
				g.setColor( COLOR_PATH );
			else
				g.setColor( COLOR_EDGE );

			g.drawLine( origine.coordX, origine.coordY, extremite.coordX, extremite.coordY );
			
			// Placer le cout de l'arete.
			if ( showGraphValues )
				PaintEdgeCost( g, route );
			
		}
	
		
		// Dessiner les sommets.
		for ( int i=0; i<graph.vTown.size(); i++ )
		{
			Town town = (Town)graph.vTown.elementAt( i );
			
			// Ovale autour du sommet
			g.setColor( COLOR_VERTEX );
			g.fillOval( town.coordX-(W_VERTEX/2), town.coordY-(H_VERTEX/2), W_VERTEX, H_VERTEX );
			g.setColor( COLOR_BORDER );
			g.drawOval( town.coordX-(W_VERTEX/2), town.coordY-(H_VERTEX/2), W_VERTEX, H_VERTEX );

			// Nom du sommet
			g.setColor( COLOR_FONT_NAME );
			g.setFont( FONT_NAME );
			g.drawString( town.name, town.coordX+DX, town.coordY+DY );

			// Valeur de l'heuristique du sommet
			if ( showGraphValues )
			{
				g.setColor( COLOR_FONT_VALUE );
				g.setFont( FONT_VALUE );
				String strValue = new Integer( town.heuristic ).toString();
				int align = (int)( - 3.6*strValue.length() + 5 );
				g.drawString( strValue, town.coordX+DX+align, town.coordY+DY+10 );
			}
			
		}
	
	}
	


	
	/**************************************************************/
	/* Methode PAINT_EDGE_COST                                    */
	/**************************************************************/
	/**
	* Place le cout d'une arete sur le dessin.
	* @param g le graphics sur lequel on est en train de dessiner.
	* @param lien le lien dont on veut ecrire les facteurs de
	* certitude.
	**/

	public void PaintEdgeCost( Graphics g, Road route )
	{
		// Sauvegarder la couleur et la fonte courantes.
		Color oldColor = g.getColor();
		Font oldFont = g.getFont();
		
		// Definir quelques variables utiles.
		Town origine =  route.origine;
		Town extremite = route.extremite;
		int middleX = Math.min( origine.coordX, extremite.coordX ) + 
		              ( Math.abs( origine.coordX - extremite.coordX ) / 2 );
		int middleY = Math.min( origine.coordY, extremite.coordY ) + 
		              ( Math.abs( origine.coordY - extremite.coordY ) / 2 );

		// Ecrire.
		g.setFont( FONT_VALUE );
		g.setColor( COLOR_FONT_VALUE );
		
		String strValue = new Integer( route.cost ).toString();
		g.drawString( strValue, middleX-10, middleY );
	
		// Restaurer la couleur et la fonte courantes.
		g.setColor( oldColor );
		g.setFont( oldFont );

	}

	
}