/**************************************************************/
/*                                                            */
/*                       Classe GRAPH                         */
/*                                                            */
/**************************************************************/


import java.util.*;


/**
* Classe Graph :
* Graphe compose de villes (sommets) et de routes (aretes).
* Utilisee pour l'exercice de recherche de chemins dans un graphe.
*
* @version 	1.0, 1 Avr 1997
* @author Bruno Sakoto
**/

public class Graph
{
	
	protected Vector vTown;      // Villes du graphe (sommets).
	protected Vector vRoad;      // Routes du graphe (aretes).
	
	protected boolean aPath[];   // Booleen indiquant quelles aretes font partie du chemin.

	
	
	/**************************************************************/
	/* Methode GRAPH                                              */
	/**************************************************************/

	public Graph()
	{
		vTown = new Vector();
		vRoad = new Vector();
		aPath = null;
	}




	/**************************************************************/
	/* Methode INIT_TOWNS                                         */
	/**************************************************************/
	/**
	* Initialise la liste des villes avec leurs proprites. 
	**/

	public void InitTowns()
	{
		vTown.addElement( new Town( "A", 48, 48 ) );
		vTown.addElement( new Town( "B", 120, 120 ) );
		vTown.addElement( new Town( "C", 48, 192 ) );
		vTown.addElement( new Town( "D", 120, 240 ) );
		vTown.addElement( new Town( "E", 204, 36 ) );
		vTown.addElement( new Town( "F", 264, 120 ) );
		vTown.addElement( new Town( "G", 480, 48 ) );
		vTown.addElement( new Town( "H", 444, 360 ) );
		vTown.addElement( new Town( "I", 204, 192 ) );
		vTown.addElement( new Town( "J", 312, 264 ) );
		vTown.addElement( new Town( "K", 192, 312 ) );
		vTown.addElement( new Town( "L", 384, 48 ) );
		vTown.addElement( new Town( "M", 408, 144 ) );
		vTown.addElement( new Town( "N", 396, 276 ) );
		vTown.addElement( new Town( "O", 360, 360 ) );
		vTown.addElement( new Town( "P", 108, 360) );
	}
	
	
	
	
	/**************************************************************/
	/* Methode INIT_ROADS                                         */
	/**************************************************************/
	/**
	* Initialise la liste des routes directes du graphe.
	**/

	public void InitRoads()
	{
		vRoad.addElement( new Road( FindTown( "A" ), FindTown( "B" ) ) );
		vRoad.addElement( new Road( FindTown( "A" ), FindTown( "E" ) ) );
		vRoad.addElement( new Road( FindTown( "B" ), FindTown( "C" ) ) );
		vRoad.addElement( new Road( FindTown( "B" ), FindTown( "E" ) ) );
		vRoad.addElement( new Road( FindTown( "B" ), FindTown( "D" ) ) );
		vRoad.addElement( new Road( FindTown( "B" ), FindTown( "I" ) ) );
		vRoad.addElement( new Road( FindTown( "B" ), FindTown( "F" ) ) );
		vRoad.addElement( new Road( FindTown( "C" ), FindTown( "D" ) ) );
		vRoad.addElement( new Road( FindTown( "C" ), FindTown( "P" ) ) );
		vRoad.addElement( new Road( FindTown( "D" ), FindTown( "I" ) ) );
		vRoad.addElement( new Road( FindTown( "D" ), FindTown( "K" ) ) );
		vRoad.addElement( new Road( FindTown( "E" ), FindTown( "F" ) ) );
		vRoad.addElement( new Road( FindTown( "E" ), FindTown( "L" ) ) );
		vRoad.addElement( new Road( FindTown( "F" ), FindTown( "I" ) ) );
		vRoad.addElement( new Road( FindTown( "F" ), FindTown( "L" ) ) );
		vRoad.addElement( new Road( FindTown( "F" ), FindTown( "M" ) ) );
		vRoad.addElement( new Road( FindTown( "G" ), FindTown( "H" ) ) );
		vRoad.addElement( new Road( FindTown( "G" ), FindTown( "L" ) ) );
		vRoad.addElement( new Road( FindTown( "G" ), FindTown( "M" ) ) );	
		vRoad.addElement( new Road( FindTown( "I" ), FindTown( "J" ) ) );
		vRoad.addElement( new Road( FindTown( "J" ), FindTown( "K" ) ) );
		vRoad.addElement( new Road( FindTown( "J" ), FindTown( "N" ) ) );	
		vRoad.addElement( new Road( FindTown( "K" ), FindTown( "O" ) ) );
		vRoad.addElement( new Road( FindTown( "K" ), FindTown( "P" ) ) );
		vRoad.addElement( new Road( FindTown( "M" ), FindTown( "N" ) ) );	
		vRoad.addElement( new Road( FindTown( "N" ), FindTown( "O" ) ) );
		vRoad.addElement( new Road( FindTown( "P" ), FindTown( "O" ) ) );	
	}




	/**************************************************************/
	/* Methode INIT_PATHS                                         */
	/**************************************************************/
	/**
	* Initialise les arcs qui font partie d'un chemin (ie aucun).
	**/

	public void InitPaths()
	{
		aPath = new boolean[vRoad.size()];
		for ( int i=0; i<vRoad.size(); i++ )
			aPath[i] = false;
	}




	/**************************************************************/
	/* Methode CREATE_NEIGHBORS_OF_TOWNS                          */
	/**************************************************************/
	/**
	* Place les voisins dans les villes a partir du vecteur des routes.
	**/

	public void CreateNeighborsOfTowns()
	{	
		Enumeration enumR = vRoad.elements();
		while ( enumR.hasMoreElements() )
		{
			Road route = (Road)enumR.nextElement();
			Town ville1 = FindTown( route.origine.name );
			Town ville2 = FindTown( route.extremite.name );
			
			if ( ville1 != null && ville2 != null )
			{
				ville1.AddRoad( ville2 );
				ville2.AddRoad( ville1 );
			}
			else
			{
				System.out.println( "\nAvertissement : " );
				System.out.println( "La route " + route.origine.name + "-" + route.extremite.name + 
				                    " ne peut pas etre definie." );
			}
		}

	}




	/**************************************************************/
	/* Methode PUT_DEFAULT_COSTS                                  */
	/**************************************************************/
	/**
	* Place les valeurs par defaut des couts des routes.
	* La valeur par defaut des couts est nulle.
	**/

	public void PutDefaultCosts()
	{
		Enumeration enum = vRoad.elements();
		while ( enum.hasMoreElements() )
		{
			Road route = (Road)enum.nextElement();
			route.cost = 0;
		}
	}
	



	/**************************************************************/
	/* Methode PUT_DEFAULT_HEURISTICS                             */
	/**************************************************************/
	/**
	* Place les valeurs heuristiques par defaut dans les villes.
	* La valeur par defaut est determinee par la distance qui separe la
	* ville de la ville d'arrivee.
	* @param strArr le nom de la ville d'arrivee.
	**/

	public void PutDefaultHeuristics( String strArr )
	{
		Town villeArr = FindTown( strArr );
		
		Enumeration enum = vTown.elements();
		while ( enum.hasMoreElements() )
		{
			Town ville = (Town)enum.nextElement();
			ville.heuristic = ville.StraightLineDistance( villeArr );
		}
	
	}




	/**************************************************************/
	/* Methode FIND_TOWN                                          */
	/**************************************************************/
	/**
	* Recherche une ville, par son nom, dans le vecteur des villes.
	* @param nom le nom de la ville recherchee.
	* @return la ville trouvee ou null si aucune
	**/
	
	public Town FindTown( String nom )
	{		
		Enumeration enumV = vTown.elements();
		while ( enumV.hasMoreElements() )
		{
			Town ville = (Town)enumV.nextElement();
			if ( ville.name.equals( nom ) )
				return ville;
		}
		
		return null;
	}




	/**************************************************************/
	/* Methode FIND_ROAD                                          */
	/**************************************************************/
	/**
	* Recherche une route (arete) parmis les routes directes du graphe.
	* @param ville1 la ville origine.
	* @param ville2 la ville extremite.
	* @return la route trouvee ou null si aucune.
	**/
	
	public Road FindRoad( Town ville1, Town ville2 )
	{
		for ( int i=0; i<vRoad.size(); i++ )
		{
			Road rte = (Road)vRoad.elementAt( i );
			
			if ( rte.origine.name.equals( ville1.name ) && rte.extremite.name.equals( ville2.name ) )
				return rte;
			if ( rte.origine.name.equals( ville2.name ) && rte.extremite.name.equals( ville1.name ) )
				return rte;

		}
		return null;
		
	}




	/**************************************************************/
	/* Methode INDEX_OF_ROAD                                      */
	/**************************************************************/
	/**
	* Recherche une route (arete) parmis les routes directes du graphe.
	* @param ville1 la ville origine.
	* @param ville2 la ville extremite.
	* @return l'index de la route dans le vecteur des routes
	* ou -1 si non trouvee.
	**/
	
	public int IndexOfRoad( Town ville1, Town ville2 )
	{
		for ( int i=0; i<vRoad.size(); i++ )
		{
			Road rte = (Road)vRoad.elementAt( i );
			
			if ( rte.origine.name.equals( ville1.name ) && rte.extremite.name.equals( ville2.name ) )
				return i;
			if ( rte.origine.name.equals( ville2.name ) && rte.extremite.name.equals( ville1.name ) )
				return i;

		}
		return -1;
		
	}


	

	/**************************************************************/
	/* Methode CREATE_PATH                                        */
	/**************************************************************/
	/**
	* Contruit un chemin dans le graphe a partir d'un noeud.
	* @param noeud le noeud representant l'extremite finale du chemin.
	**/
	
	public void CreatePath( Node noeud )
	{
		Node noeudCour = noeud;
		do 
		{
			if ( noeudCour.ancestor != null )
			{		
				Town ville1 = noeudCour.ancestor.description;
				Town ville2 = noeudCour.description;
				aPath[IndexOfRoad( ville1, ville2 )] = true;
			}
			
			noeudCour = noeudCour.ancestor;
		}
		while ( noeudCour != null );

	}


}