/**************************************************************/
/*                                                            */
/*                    Classe COST_WINDOW                      */
/*                                                            */
/**************************************************************/


import java.awt.*;
import java.util.*;


/**
* Classe CostWindow :
* Fenetre de gestion des valeurs des couts des aretes du graphe.
* Utilisee pour l'exercice de recherche de chemins dans un graphe.
*
* @version 	1.0, 1 AvrMar 1997
* @author Bruno Sakoto
**/

public class CostWindow extends Frame
{
	protected TextField routeTF[];
	protected TextField coutTF[];
	protected Button zeroButton;
	protected Button unButton;
	protected Button distanceButton;
	protected Button cancelButton;
	protected Button okButton;
	
	protected AlertDialog dialog;

	protected Vector vRoad;    	 // Vecteur des routes du graphe (aretes).
	protected Vector vRoadTmp;	 // Copie de travail du vecteur des routes. 
	
	protected Component caller;
	
	

	/**************************************************************/
	/* Methode COST_WINDOW                                        */
	/**************************************************************/

	public CostWindow( Component caller, Vector vect )
	{
		super( "Costs" );
	
		// Initialisation des proprietes.
		this.caller = caller;
		vRoad = vect;
		
		vRoadTmp = new Vector();
		Enumeration enum = vRoad.elements();
		while ( enum.hasMoreElements() )
			vRoadTmp.addElement( ((Road)enum.nextElement()).Copy() );
			
		routeTF = new TextField[ vRoad.size() ];
		coutTF = new TextField[ vRoad.size() ];
		
		
		for ( int i=0; i<vRoad.size(); i++ )
		{
			Town ville1 = ((Road)vRoad.elementAt( i )).origine;
			Town ville2 = ((Road)vRoad.elementAt( i )).extremite;

			routeTF[i] = new TextField( ville1.name + "-" + ville2.name, 4 );
			routeTF[i].setEditable( false );
			Integer val = new Integer( ((Road)vRoad.elementAt(i)).cost );
			coutTF[i] = new TextField( val.toString(), 4 );
		}
		
		
		// Fixer le layout.		
		GridBagLayout gridbag = new GridBagLayout();
		setLayout( gridbag );
		
		
		// Mise en place des noms de sommets et des heuristiques.
		int mid = vRoad.size()/2;
		for ( int i=0; i<mid; i++ )
		{
			Constrain.constrain( this, routeTF[i], 0, i, 1, 1 );		
			Constrain.constrain( this, coutTF[i], 1, i, 1, 1, 0, 0, 0, 0 );
		}
		for ( int i=mid; i<vRoad.size(); i++ )
		{
			Constrain.constrain( this, routeTF[i], 3, i-mid, 1, 1, 0, 0, 0, 0 );		
			Constrain.constrain( this, coutTF[i], 4, i-mid, 1, 1 );
		}

		
		// Mise en place du bouton de mise a zero.
		zeroButton = new Button( "All to 0" );
		Constrain.constrain( this, zeroButton, 0, mid+1, 2, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 30, 0, 0, 30 );

		// Mise en place du bouton de mise a un.
		unButton = new Button( "  All to 1  " );
		Constrain.constrain( this, unButton, 2, mid+1, 1, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 30, 0, 0, 0 );

		// Mise en place du bouton de distance.
		distanceButton = new Button( "Distance" );
		Constrain.constrain( this, distanceButton, 3, mid+1, 2, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 30, 30, 0, 0 );

		// Mise en place du bouton d'annulation.
		cancelButton = new Button( "Cancel" );
		Constrain.constrain( this, cancelButton, 0, mid+2, 2, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 15, 0, 0, 30 );
		
		// Mise en place du bouton de validation.
		okButton = new Button( "Enter" );
		Constrain.constrain( this, okButton, 3, mid+2, 2, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 15, 30, 0, 0 );


		// Deplacer et dimensionner la fenetre.
		move( 500, 150 );
		pack();
		resize( size().width+60, size().height+60 );
		setResizable( false );
			
		show();
	}



	
	/**************************************************************/
	/* Methode SET_COSTS_VAL                                      */
	/**************************************************************/
	/**
	* Permet de placer les valeurs des couts dans les TextFields.
	* Les valeurs contenues dans vRoadTmp sont utilisees.
	**/

	public void SetCostsVal()
	{
		for ( int i=0; i<vRoadTmp.size(); i++ )
		{
			Integer val = new Integer( ((Road)vRoadTmp.elementAt(i)).cost );
			coutTF[i].setText( val.toString() );
		}
	}


	
	
	/**************************************************************/
	/* Methode SAVE_COSTS_VAL                                     */
	/**************************************************************/
	/**
	* Permet de sauver les valeurs des couts des TextFields
	* dans les couts des routes du graphe.
	* @return vrai si la mise a jour a pu avoir lieu.
	**/

	public boolean SaveCostsVal()
	{
		// Verifier que les valeurs sont des entiers.
		for ( int i=0; i<vRoadTmp.size(); i++ )
		{
			try
			{	
				Integer val = new Integer( coutTF[i].getText() );
			}
			catch ( NumberFormatException e )  
			{
				String str = new String( "Wrong value for the cost of the edge " +
				                         ((Road)vRoad.elementAt( i )).origine.name + "-" +
				                         ((Road)vRoad.elementAt( i )).extremite.name + " ."); 
				dialog = new AlertDialog( this, str );
				dialog.move( 300, 300 );
				dialog.show();
			
				return false;
			}
			
		}
		
		// Effectuer la mise a jour.
		for ( int i=0; i<vRoadTmp.size(); i++ )
		{
			Integer val = new Integer( coutTF[i].getText() );
			((Road)vRoad.elementAt( i )).cost = val.intValue();
		}
		
		return true;
	}

	


	/**************************************************************/
	/* Methode ACTION                                             */
	/**************************************************************/
	/**
	* Apellee si une action intervient dans le paneau de controle.
	**/
	
	public boolean action( Event evt, Object arg )
	{
	
		if ( evt.target == distanceButton )
		{
			// DISTANCE_BUTTON
		
			// Mettre dans les couts de vRoadTmp les distance des aretes
			Enumeration enum = vRoadTmp.elements();
			while ( enum.hasMoreElements() )
			{
				Road route = (Road)enum.nextElement();
				route.cost = route.StraightLineDistance();
			}
			
			// Placer les nouvelles valeurs dans les TextFields
			SetCostsVal();

			return true;
		}
	
	
		if ( evt.target == unButton )
		{
			// TO_1_BUTTON
		
			// Mettre a un tous les couts (dans vRoadTmp).
			Enumeration enum = vRoadTmp.elements();
			while ( enum.hasMoreElements() )
			{
				Road route = (Road)enum.nextElement();
				route.cost = 1;
			}
			
			// Placer les nouvelles valeurs dans les TextFields
			SetCostsVal();
			
			return true;
		}

	
		if ( evt.target == zeroButton )
		{
			// TO_0_BUTTON
		
			// Mettre a zero tous les couts (dans vRoadTmp).
			Enumeration enum = vRoadTmp.elements();
			while ( enum.hasMoreElements() )
			{
				Road route = (Road)enum.nextElement();
				route.cost = 0;
			}
			
			// Placer les nouvelles valeurs dans les TextFields
			SetCostsVal();
			
			return true;
		}


		if ( evt.target == cancelButton )
		{
			// CANCEL_BUTTON
			caller.enable();
			dispose();
			return true;
		}

	
		if ( evt.target == okButton )
		{
			// OK_BUTTON 
			if ( SaveCostsVal() )
			{	
				((SearchApplet)caller).dessin.repaint();			
				caller.enable();
				dispose();
			}
			return true;
		}
		
		return false;
	}

}