/**************************************************************/
/*                                                            */
/*                   Classe CONTROL_PANEL                     */
/*                                                            */
/**************************************************************/


import java.awt.*;


/**
* Classe ControlPanel :
* Permet de realiser le panneau de controle.
* Utilisee pour l'exercice de recherche de chemins dans un graphe.
*
* @version 	1.0, 1 Avr 1997
* @author Bruno Sakoto
**/

public class ControlPanel extends Panel
{
	protected Choice depChoice;
	protected Choice arrChoice;
	protected Choice algoChoice;
	protected Button heuristicButton;
	protected Button costButton;
	protected Checkbox stepCheckbox;
	protected Checkbox showCheckbox;
	protected Button okButton;
	

	
	/**************************************************************/
	/* Methode CONTROL_PANEL                                      */
	/**************************************************************/
	/**
	* Construit un panneau de controle avec ses differents composants.
	**/
	
	public ControlPanel()
	{
		// Fixer le Layout.
		GridBagLayout gridbag = new GridBagLayout();		
		setLayout( gridbag );
		
		// Choix du sommet de depart.
		Constrain.constrain( this, new Label( "Begin :" ), 0, 0, 1, 1, 15, 15, 0, 0 );
		depChoice = new Choice();
		for ( int i=0; i<SearchApplet.work.graph.vTown.size(); i++ )
			depChoice.addItem( ((Town)SearchApplet.work.graph.vTown.elementAt(i)).name );
		Constrain.constrain( this, depChoice, 1, 0, 1, 1, 15, 15, 0, 15 );

		// Choix du sommet d'arrivee.
		Constrain.constrain( this, new Label( "End :" ), 0, 1, 1, 1, 15, 15, 0, 0 );
		arrChoice = new Choice();
		for ( int i=0; i<SearchApplet.work.graph.vTown.size(); i++ )
			arrChoice.addItem( ((Town)SearchApplet.work.graph.vTown.elementAt(i)).name );
		arrChoice.select( ((Town)SearchApplet.work.graph.vTown.elementAt(7)).name );
		Constrain.constrain( this, arrChoice, 1, 1, 1, 1, 15, 15, 0, 15 );
		
		// Choix de l'algorithme de recherche.
		Constrain.constrain( this, new Label( "Method :" ), 0, 2, 1, 1, 15, 15, 0, 0 );
		algoChoice = new Choice();
		algoChoice.addItem( Work.A_STAR );
		algoChoice.addItem( Work.LARGEUR_DABORD );
		algoChoice.addItem( Work.PROFONDEUR_DABORD );
		Constrain.constrain( this, algoChoice, 1, 2, 1, 1, 15, 15, 0, 15 );


		// Bouton de modification des couts des aretes.
		costButton = new Button( "Costs" );
		Constrain.constrain( this, costButton, 0, 3, 1, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 15, 15, 0, 0 );

		// Bouton de modification des heuristiques en chaque sommet.
		heuristicButton = new Button( "Heuristics" );
		Constrain.constrain( this, heuristicButton, 1, 3, 1, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 15, 40, 0, 15 );

		// Proposition de l'execution pas a pas.
		stepCheckbox = new Checkbox( "Step by step execution" );
		Constrain.constrain( this, stepCheckbox, 0, 5, 2, 1, 15, 15, 0, 15 ); 
		
		// Proposition d'affichage des couts et heuristiques sur le graphe.
		showCheckbox = new Checkbox( "Show values on graph" );
		Constrain.constrain( this, showCheckbox, 0, 6, 2, 1, 15, 15, 15, 15 ); 

		
		// Bouton de lancement de la recherche.
		okButton = new Button( "Search" );
		Constrain.constrain( this, okButton, 0, 7, 2, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 30, 15, 15, 15 );

	}
	
	

	
	/**************************************************************/
	/* Methode ACTION                                             */
	/**************************************************************/
	/**
	* Apellee si une action intervient dans le paneau de controle.
	**/
	
	public boolean action( Event evt, Object arg )
	{
	
		if ( evt.target == arrChoice )
		{
			// ARR_CHOICE
			
			// Mettre les nouvelles valeurs des heuristiques.
			SearchApplet.work.graph.PutDefaultHeuristics( arrChoice.getSelectedItem() );
			
			// Redessiner le graphe.
			SearchApplet applet = (SearchApplet)this.getParent();
			if ( applet.dessin.showGraphValues ) 
				applet.dessin.repaint();

			return true;
		}
		
		
		if ( evt.target == showCheckbox )
		{
			// SHOW_CHECKBOX
			SearchApplet applet = (SearchApplet)this.getParent();
			applet.dessin.showGraphValues = showCheckbox.getState();
			applet.dessin.repaint();
			return true;
		}
		
	
		if ( evt.target == okButton )
		{
			// OK_BUTTON
			
			// Lancer la recherche.
			String methode = algoChoice.getSelectedItem();
			if ( methode.equals( Work.A_STAR ) )
				SearchApplet.work.DoStarSearch( (SearchApplet)this.getParent() );
			else
				SearchApplet.work.DoSimpleSearch( (SearchApplet)this.getParent() );
				
			return true;
		}
		
		
		if ( evt.target == costButton )
		{
			// COST_BUTTON
						
			// Desactiver le panneau de controle.
			this.getParent().disable();
			
			// Ouvrir la fenetre de modification des couts.
			CostWindow cWin = new CostWindow( (SearchApplet)this.getParent(), 
			                                   SearchApplet.work.graph.vRoad );

			return true;
		}

		
		if ( evt.target == heuristicButton )
		{
			// HEURISTIC_BUTTON
						
			// Desactiver le panneau de controle.
			this.getParent().disable();
			
			// Ouvrir la fenetre de modification des heuristiques.
			Town arrTown = SearchApplet.work.graph.FindTown( arrChoice.getSelectedItem() );
			HeuristicWindow hWin = new HeuristicWindow( (SearchApplet)this.getParent(), 
			                                             SearchApplet.work.graph.vTown, 
			                                             arrTown );
			
			return true;
		}

		
		return false;	
 
	}
	
	
}