/**************************************************************/
/*                                                            */
/*                    Classe ALERT_DIALOG                     */
/*                                                            */
/**************************************************************/


import java.awt.*;


/**
* Classe AlertDialog :
* Permet de realiser des boites de dialogue pour informer
* l'utilisateur que des donnees incorectes ont ete saisies.
*
* @version 	1.0, 1 Avr 1997
* @author Bruno Sakoto
**/

class AlertDialog extends Dialog
{


	/**************************************************************/
	/* Methode ALERT_DIALOG                                       */
	/**************************************************************/
	/**
	* Cree une boite de dialogue contenant un message donne.
	* @param parent la frame proprietaire de la boite.
	* @param message le message a faire figurer dans la boite. 
	**/

	public AlertDialog( Frame parent, String message )
	{
		super( parent, "Erreur!", true );
		
		add( "Center", new Label( message ) );
		Panel thePanel = new Panel();
		thePanel.add( new Button( "Ok" ) );
		add( "South", thePanel );
		
		pack();
		setResizable( false );
		
	}
	


	
	/**************************************************************/
	/* Methode ACTION                                             */
	/**************************************************************/
	/**
	* Apellee si une action intervient dans la boite de dialogue.
	**/
	
	public boolean action( Event evt, Object arg )
	{
		if ( "Ok".equals( arg ) )
		{
			dispose();
			return true;
		}
		return false;
	}

}