from moteur_psc.variable import Variable

class VariableAvecLabel(Variable):
    """ Modélisation d'une variable munie d'un label dans un système de\
        contraintes.
    """

    def __init__(self, nom, domaine, val=None):
        """ 
            :param str nom: nom de la variable.
            :param list domaine: le domaine de définition de la variable.
            :param val: valeur de départ.
        """

        Variable.__init__(self, nom, domaine, val)

        # Le label est initialement égal au domaine.
        self.label = domaine[:]

    def __repr__(self):
        return '{} = {}, domaine: {}, label: {}'.format(self.nom, 
                                                        self.val, 
                                                        self.domaine, 
                                                        self.label)