from moteur_psc.psc import PSC

class PSCHeuristique(PSC):

    def __init__(self, variables, contraintes):
        """ 
            :param list variables: les variables du problème.
            :param list contraintes: les contraintes du problème.
        """

        PSC.__init__(self, variables, contraintes)

        self.reinitialise()
        
    def reinitialise(self):
        """ Réinitialise les attributs du problème.

            Après l'appel à cette méthode, les labels des variables sont à\
            nouveau égaux aux domaines complets, et les variables ont une\
            valeurs indéfinie (égale à ``None``).
        """

        self.initialise_labels()
        self.solutions = []
        self.iterations = 0

    def initialise_labels(self):
        """ Initialise les labels pour les rendre identiques aux domaines. """

        for var in self.variables:
            var.label = var.domaine[:]

    def consistance_noeuds(self):
        """ Applique la consistance des noeuds sur les contraintes unaires du\
            problème.

            L'algorithme consiste à enlever des domaines de définition toutes\
            les valeurs qui violent les contraintes unaires.
        """

        # Nous appelons d'abord la méthode de la classe-mère PSC pour réduire
        # les domaines.
        PSC.consistance_noeuds(self)

        # Puis, nous nous assurons que les labels sont identiques aux domaines.
        self.initialise_labels()

    def variable_ordering(self):
        """ Trie les variables par ordre croissant de taille de domaine."""

        print('à compléter')

    def dynamic_variable_ordering(self, k):
        """ Place en position ``k`` la variable non instanciée dotée du label le\
            plus restreint.

            :param k: profondeur actuelle de la recherche.
        """

        print('à compléter')

    def propagation_consistante(self, k):
        """ Propage la valeur de la variable actuelle sur les variables\
            suivantes.

            Pour chaque contrainte portant sur la variable courante et sur une\
            ou plusieurs des variables non encore instanciée, appelle la methode\
            ``propage`` de la contrainte pour réduire le label de la deuxième\
            variable.

            :param k: profondeur actuelle de la recherche.
            :return: ``True`` si la valeur de la dernière variable instanciée\
            n'empêche pas l'instanciation des variables suivantes.
        """

        print('à compléter')

    def forward_checking(self, k=0, une_seule_solution=False):
        """ Algorithme du Forward Checking.

            Le Forward Checking essaie de limiter les retours en arrière en\
            restreignant les domaines des variables non instanciées\
            (par application de la consistance des arcs à chaque itération).

            :param une_seule_solution: retourne après avoir trouvé la première\
            solution.
            :param k: la profondeur actuelle de la recherhe.
        """

        print('à compléter')