from moteur_psc.contrainte import ContrainteBinaire

class ContrainteAvecPropagation(ContrainteBinaire):
    """ Contrainte imposant une restriction sur deux variables avec la méthode\
        ``propage``.
        
        Exemple: ``x > y``.
    """

    def __init__(self, var1, var2, op):
        """ Exemples d'op: ``lambda x,y: x != y``, ``lambda x,y: x < y``.
            
            :param var1: première variable concernée par la contrainte.
            :param var2: deuxième variable concernée par la contrainte.
            :param op: fonction ou expression lambda permettant de vérifier la\
            contrainte.
        """

        ContrainteBinaire.__init__(self, var1, var2, op)

    def reviser(self):
        """ Algorithme de révision des domaines.

            Pour chaque variable, vérifie chaque valeur du domaine. Supprime\
            les valeurs qui empêchent la contrainte d'être satisfaite dans le\
            domaine.

            :return: ``True`` si un des domaines a été modifié.
        """

        # Nous appliquons d'abord la méthode reviser() de la classe-mère pour
        # réviser les domaines de chaque variable.
        domaines_modifies = ContrainteBinaire.reviser(self)

        # Puis, s'il y a lieu, nous nous assurons que les labels sont toujours
        # identiques aux domaines.
        if domaines_modifies:
            for var in self.variables:
                var.label = var.domaine[:]

        return domaines_modifies


    def propage(self, var):
        """ Propage l'assignation d'une variable au label de la seconde.

            :param var: la variable fixée.
            :return: ``True`` si la contrainte est toujours satisfaisable avec\
            la valeur fixée.
        """

        print('à compléter')