from sys import argv, exit
from moteur_psc_heuristique.variable_avec_label import VariableAvecLabel
from moteur_psc.contrainte import ContrainteUnaire
from moteur_psc_heuristique.contrainte_avec_propagation import ContrainteAvecPropagation
from moteur_psc_heuristique.psc_heuristique import PSCHeuristique
from sudoku import Sudoku

grilleA = [
    [ 9 ,'-','-','-','-','-','-','-', 2],
    [ 3 ,'-', 7 , 1 ,'-','-', 4 ,'-', 8],
    ['-', 1 ,'-','-', 5 , 4 ,'-', 6 ,'-'],
    ['-','-', 1 ,'-','-','-','-', 7 ,'-'],
    ['-','-', 4 ,'-','-','-', 9 ,'-','-'],
    ['-', 2 ,'-','-','-','-', 8 ,'-','-'],
    ['-', 8 ,'-', 3 , 2 ,'-','-', 4 ,'-'],
    [ 7 ,'-', 3 ,'-','-', 6 , 2 ,'-', 1],
    [ 4 ,'-','-','-','-','-','-','-', 5]
]

grilleB = [
    ['-','-','-','-','-','-','-','-','-'],
    ['-','-', 7 , 8 , 3 ,'-', 9 ,'-','-'],
    ['-','-', 5 ,'-','-', 2 , 6 , 4 ,'-'],
    ['-','-', 2 , 6 ,'-','-','-', 7 ,'-'],
    ['-', 4 ,'-','-','-','-','-', 8 ,'-'],
    ['-', 6 ,'-','-','-', 3 , 2 ,'-','-'],
    ['-', 2 , 8 , 4 ,'-','-', 5 ,'-','-'],
    ['-','-','-','-', 9 , 6 , 1 ,'-','-'],
    ['-','-','-','-','-','-','-','-','-']
]

if len(argv) < 3:
    print('On attend deux arguments: grille (A ou B) ' +\
          'et méthode (forward_checking ou backtracking)')
    exit(1)

if argv[1].lower() == 'a':
    sudoku = Sudoku(grilleA)
elif argv[1].lower() == 'b':
    sudoku = Sudoku(grilleB)
else:
    print('Le premier argument doit être A ou B')
    exit(1)

if argv[2] in ('backtracking', 'forward_checking'):
    methode = argv[2]
else:
    print('Le second argument doit être forward_checking ou backtracking')
    sys.exit(1)

print('Grille ' + argv[1])
print(sudoku)

sudoku.resoudre(methode)

print(sudoku)