from moteur_psc_heuristique.variable_avec_label import VariableAvecLabel
from moteur_psc.contrainte import ContrainteUnaire
from moteur_psc_heuristique.contrainte_avec_propagation import ContrainteAvecPropagation
from moteur_psc_heuristique.psc_heuristique import PSCHeuristique

variables = [
             VariableAvecLabel('a', [2, 3]),
             VariableAvecLabel('b', list(range(12))),
             VariableAvecLabel('c', list(range(3))),
             VariableAvecLabel('d', list(range(3))),
             VariableAvecLabel('e', list(range(12))),
             ]

contraintes = [
    ContrainteUnaire(variables[1], lambda x: x < 4),
    ContrainteAvecPropagation(variables[0], variables[1], lambda x, y: x != y),
    ContrainteAvecPropagation(variables[1], variables[2], lambda x, y: x != y),
    ContrainteAvecPropagation(variables[1], variables[3], lambda x, y: x != y),
    ContrainteAvecPropagation(variables[1], variables[4], lambda x, y: x != y),
    ContrainteAvecPropagation(variables[2], variables[3], lambda x, y: x != y),
    ContrainteAvecPropagation(variables[2], variables[4], lambda x, y: x != y),
    ContrainteAvecPropagation(variables[3], variables[4], lambda x, y: x != y),
    ContrainteAvecPropagation(variables[4], variables[0], lambda x, y: x < y),
]

psc = PSCHeuristique(variables, contraintes)

psc.consistance_noeuds()
psc.consistance_arcs()
psc.variable_ordering()

psc.backtracking()

print('Backtracking avec variable ordering: ')
psc.affiche_solutions()

psc.reinitialise()
psc.forward_checking()

print('Forward checking: ') 
psc.affiche_solutions()