from unittest import TestCase
from moteurs_recherche.ville import Ville
from moteurs_recherche.espace import Espace
from moteurs_recherche.noeud import Noeud
from moteurs_recherche.recherche import Recherche
from moteurs_recherche.dfs import RechercheDFS

class TestDFS(TestCase):

    def setUp(self):
        self.elements = {
            'a': Ville(0, 0, 'a'),
            'b': Ville(0, 1, 'b'),
            'c': Ville(1, 0, 'c'),
            'd': Ville(-1, 0, 'd'),
            'e': Ville(0, -1, 'e'),
        }

        self.espace = Espace([self.elements['a'], self.elements['b'], 
                              self.elements['c'], self.elements['d'], 
                              self.elements['e']],
                [(self.elements['a'], self.elements['b']), 
                 (self.elements['a'], self.elements['c']), 
                 (self.elements['a'], self.elements['d'])])

    def test_ajoute_successeurs(self):
        dfs = RechercheDFS(self.espace)
        dfs.h = lambda e: 1

        queue = [Noeud(self.elements['b'])]
        succeseurs = dfs.trouve_successeurs(Noeud(self.elements['a']))
        queue = dfs.ajoute_successeurs(queue, succeseurs)

        elements = [n.element for n in queue]
        self.assertListEqual(elements,
                             [self.elements['b'], self.elements['c'], 
                              self.elements['d'], self.elements['b']])

    def test_dfs(self):
        self.assertEqual(RechercheDFS(self.espace).recherche(self.elements['a'], self.elements['b']), 
                         [self.elements['a'], self.elements['b']])
        self.assertEqual(RechercheDFS(self.espace).recherche(self.elements['a'], self.elements['c']), 
                         [self.elements['a'], self.elements['c']])
        self.assertEqual(RechercheDFS(self.espace).recherche(self.elements['a'], self.elements['e']), 
                         Recherche.echec)
