from unittest import TestCase
from moteurs_recherche.ville import Ville
from moteurs_recherche.espace import Espace
from moteurs_recherche.noeud import Noeud
from moteurs_recherche.recherche import Recherche
from moteurs_recherche.bfs import RechercheBFS

class TestBFS(TestCase):

    def setUp(self):
        self.elements = {
            'a': Ville(0, 0, 'a'),
            'b': Ville(0, 1, 'b'),
            'c': Ville(1, 0, 'c'),
            'd': Ville(-1, 0, 'd'),
            'e': Ville(0, -1, 'e'),
        }

        self.espace = Espace([self.elements['a'], self.elements['b'], 
                              self.elements['c'], self.elements['d'], 
                              self.elements['e']],
                [(self.elements['a'], self.elements['b']), 
                 (self.elements['a'], self.elements['c']), 
                 (self.elements['a'], self.elements['d'])])

    def test_ajoute_successeurs(self):
        bfs = RechercheBFS(self.espace)
        bfs.h = lambda e: 1

        # Ajoute avec aucun noeud visités (b sera à double dans la liste).
        queue = [Noeud(self.elements['b'])]
        succeseurs = bfs.trouve_successeurs(Noeud(self.elements['a']))
        queue = bfs.ajoute_successeurs(queue, succeseurs)
        
        elements = [n.element for n in queue]
        self.assertListEqual(elements,
                             [self.elements['b'], self.elements['b'], 
                              self.elements['c'], self.elements['d']])

    def test_bfs(self):
        self.assertEqual(RechercheBFS(self.espace).recherche(self.elements['a'], self.elements['b']), 
                         [self.elements['a'], self.elements['b']])
        self.assertEqual(RechercheBFS(self.espace).recherche(self.elements['a'], self.elements['c']), 
                         [self.elements['a'], self.elements['c']])
        self.assertEqual(RechercheBFS(self.espace).recherche(self.elements['a'], self.elements['e']), 
                         Recherche.echec)
