from .noeud import Noeud

class Recherche:
    """ Classe générique pour la recherche. """

    echec = 'échec'

    def __init__(self, espace, optimisee=False):
        """
            :param espace: l'espace de recherche.
            :param optimiser: indique si la recherche doit être optimisée pour éviter\
            les cycles.
        """

        self.espace = espace
        self.optimisee = optimisee
        
    def recherche(self, depart, but): 
        """ Recherche un chemin allant de ``depart`` jusqu'à ``but``.

            :param depart: l'élément de départ.
            :param but: le l'élément but.

            :return: le chemin de ``depart `` à ``but``, ou ``'échec'``\
            s'il n'existe pas de chemin.
        """

        # L'heuristique à utiliser (utile uniquement pour A\*).
        self.h = lambda e: e.distance(but)

        noeud_depart = Noeud(depart, None, 0, self.h(depart))
        noeud_but = Noeud(but)

        return self.recherche_chemin(noeud_depart, noeud_but)

    def recherche_chemin(self, noeud_depart, noeud_but):
        """ Recherche un chemin allant de ``depart`` jusqu'à ``but``.

            :param noeud_depart: le noeud de départ.
            :param noeud_but: le noeud but.

            :return: les éléments encapsulés au long du chemin,\
            ou ``'échec'`` s'il n'existe pas de chemin.
        """

        print('à compléter')

    def trouve_chemin(self, noeud):
        chemin = []
        while noeud is not None:
            chemin.insert(0, noeud.element)
            noeud = noeud.parent
        
        return chemin

    def detecte_cycle(self, trace, noeud):
        """ Vérifie si le noeud courant a déjà été visité par un autre chemin,\
            et donc si l'on vient de parcourir un cycle dans l'espace de recherche. 

            :param dict trace: un dictionnaire contenant les noeuds déjà visités ;\
            le dictionnaire associe à chaque élément le noeud qui l'encapsule.\
            Cela permet de tester rapidement si l'élément du noeud courant est\
            présent dans un autre noeud déjà visité.
            :return: True si le noeud courant a déjà été visité.
        """

        return noeud.element in trace

    def trouve_successeurs(self, noeud):
        """ Trouve les successeurs du noeud courant.

            :return: une liste contenant les noeuds successeurs du noeud courant.
        """ 

        print('à compléter')

    def ajoute_successeurs(self, queue, successeurs):
        """ Ajoute les successeurs ``successeurs`` à la queue ``queue``\
            (à implémenter différemment pour DFS, BFS et A\*).

            La queue peut éventuellement être modifiée par la méthode.

            :param list queue: la queue des noeuds à explorer.
            :param list successeurs: les successeurs à ajouter.
            :return: la queue contenant tous les successeurs dans le\
            bon ordre.
        """

        # Nous retournons une liste vide pour éviter de déclencher une exception,
        # mais cette méthode doit être surchargée dans les sous-classes.
        return []