from moteur_planification.operateur import Operateur
from moteur_planification.planification import Planification

def format_g(acteur):
    """ Retourne une string représentant un acteur à gauche. """

    return 'g({})'.format(acteur)
    
def format_d(acteur):
    """ Retourne une string représentant un acteur à droite. """

    return 'd({})'.format(acteur)
    
def format_dg(bateau, pilote):
    """ Retourne une string représentant une traversée de droite à gauche. """

    return 'dg({}, {})'.format(bateau, pilote)
    
def format_gd(bateau, pilote, passager):
    """ Retourne une string représentant une traversée de gauche à droite. """

    return 'gd({}, {}, {})'.format(bateau, pilote, passager)


bateaux = ['B']
missionnaires = ['M1', 'M2']
cannibales = ['C1', 'C2']

acteurs = bateaux + missionnaires + cannibales

# Ajoute les propositions pour la position des acteurs.
propositions = []
print('à compléter')

# Ajoute les opérateurs de déplacement.
operateurs = []
print('à compléter')

# Ajoute les mutex de proposition (un acteur ne peut pas être sur les deux rives 
# simultanément).
mutex_propositions = []
print('à compléter')

# Ajoute les mutex d'opérateurs.
mutex_operateurs = []
print('à compléter')

# Ajoute les contraintes initiales (tous les acteurs à gauche).
depart = []
print('à compléter')

# Ajoute les contraintes finales (but: tous les acteurs à droite).
but = []
print('à compléter')

# Transforme le problème de planification en PSC.
plan = Planification(propositions, operateurs, 
                     mutex_propositions, mutex_operateurs, 
                     depart, but, 
                     nb_etats=5)
plan.resoudre()

plan.affice_solutions()