from unittest import TestCase
from moteur_avec_variables.regle_avec_variables import RegleAvecVariables
from moteur_avec_variables.filtre import Filtre 

class TestRegleAvecVariables(TestCase):

    def setUp(self):
        self.r1 = RegleAvecVariables([('?x', 'vole')], ('?x', 'est un oiseau'))
        self.r2 = RegleAvecVariables([('a', '?y'), '?x'], ('?x', '?y'))

    def test_depend_de(self):
        filtre = Filtre()     
        self.assertEqual(self.r1.depend_de(('Titi', 'vole'), filtre),
                         {('?x', 'vole'): {'?x': 'Titi'}})
        self.assertFalse(self.r1.depend_de(('Titi', 'ne vole pas'), filtre))
        self.assertEqual(self.r2.depend_de('b',filtre), {'?x': {'?x': 'b'}})

    def test_satisfaite_par(self):
        filtre = Filtre()
        faits = [('Titi', 'vole')]
        self.assertEqual(self.r1.satisfaite_par(faits, None, {}, filtre),
                         [{'?x': 'Titi'}])

        faits = [('a', 'c'), ('b')]
        self.assertTrue({'?x': 'b', '?y': 'c'} in self.r2.satisfaite_par(faits, None, {'?y': 'c'}, filtre))
        self.assertFalse(self.r2.satisfaite_par(faits, None, {'?y': 'b'}, filtre))
        self.assertFalse(self.r2.satisfaite_par([('a', 'c')], None, {'?x': 'c'}, filtre))