from unittest import TestCase
from moteur_avec_variables.filtre import Filtre

class TestFiltre(TestCase):

    def test_substitue(self):
        pattern = ('?y', 'is', '?x')
        env = {'?x': 'connu'}
        filtre = Filtre()
        self.assertEqual(filtre.substitue(pattern, env), ('?y', 'is', 'connu'))

    def test_substitue_single_elements(self):
        filtre = Filtre()
        self.assertEqual(filtre.substitue('?x', {'?x': 'connu'}), 'connu')

    def test_substitue_recursif(self):
        pattern = ('?y', 'et', ('?x'))
        env = {'?x': 'Dupont', '?y': 'Dupond'}
        filtre = Filtre()
        self.assertEqual(filtre.substitue(pattern, env), 
                         ('Dupond', 'et', ('Dupont')))

    def test_filtre_simple(self):
        pattern = ('?x', 'is', '?y')
        datum = ('The night', 'is', 'dark')
        filtre = Filtre()

        self.assertEqual(filtre.filtre(datum, pattern), {'?x': 'The night',
                                                         '?y': 'dark'})

        self.assertEqual(filtre.filtre(('Vincent', 'est un', 'doctorant'),
                                       ('Vincent', 'est un', 'doctorant')),
                                       {})

        self.assertEqual(filtre.filtre('Vincent', '?x'), {'?x': 'Vincent'})

        self.assertEqual(filtre.filtre(('Vincent', 'est un', ('Vincent', 'est un', 'doctorant')),
                                       ('Vincent', 'est un', ('Vincent', 'est un', 'doctorant'))),
                                       {})


        self.assertEqual(filtre.filtre(('Vincent', 'est un', 'doctorant', 'Paolo', 'est un', 'doctorant'),
                                       ('?x', 'est un', '?y', '?z', 'est un', '?v')),
                                       {'?x': 'Vincent', '?y': 'doctorant', '?z': 'Paolo', '?v': 'doctorant'})

        self.assertEqual(filtre.filtre(('Vincent', 'est un', 'Vincent'),
                                       ('?x', 'est un', '?x')),
                                       {'?x': 'Vincent'})
    def test_filtre_nested(self):
        pattern = ('foo', 'Jean', ('Marc', 'bar', 'Paul'))
        datum = ('foo', '?x', ('?y', 'bar', '?z'))

        filtre = Filtre()
        self.assertEqual(filtre.filtre(pattern, datum), {'?x': 'Jean',
                                                         '?y': 'Marc',
                                                         '?z': 'Paul'})

    def test_filtre_unmatchable(self):
        pattern = ('?x', 'is', '?x')
        datum = ('The night', 'is', 'dark')

        filtre = Filtre()
        self.assertEqual(filtre.filtre(datum, pattern), Filtre.echec)

        self.assertEqual(filtre.filtre(('Vincent', 'est un', 'doctorant'),
                                       ('Paolo', 'est un', 'doctorant')), Filtre.echec)

        self.assertEqual(filtre.filtre(('Vincent', 'est un', 'doctorant'),
                                       ('Vincent', 'est un', ('Vincent', 'est un', 'doctorant'))), Filtre.echec)

        self.assertEqual(filtre.filtre(('Vincent', 'est un', 'doctorant'),
                                       ('?x', 'est un', '?x')), Filtre.echec)

    def test_filtre_datum_too_short(self):
        pattern = ('?x', 'is', '?y')
        datum = ('The night', 'is')

        filtre = Filtre()
        self.assertEqual(filtre.filtre(datum, pattern), Filtre.echec)