from sys import argv, exit
from moteur_avec_variables.regle_avec_variables import RegleAvecVariables
from moteur_sans_variables.connaissance import BaseConnaissances
from moteur_avec_variables.filtre import Filtre
from moteur_avec_variables.unificateur import Unificateur
from moteur_avec_variables.chainage_avant_avec_variables import ChainageAvantAvecVariables

faits_initiaux = [
    ('add', '0', '0', '0', '0'),
    ('add', '100', '100', '0', '0'),
    ('add', '100', '0', '100', '0'),
    ('add', '200', '100', '100', '0'),
    ('add', '200', '0', '200', '0'),
    ('add', '300', '100', '200', '0'),
    ('add', '50', '0', '0', '50'),
    ('add', '150', '100', '0', '50'),
    ('add', '150', '0', '100', '50'),
    ('add', '250', '100', '100', '50'),
    ('add', '250', '0', '200', '50'),
    ('add', '350', '100', '200', '50'),
    ('add', '100', '0', '0', '100'),
    ('add', '200', '100', '0', '100'),
    ('add', '200', '0', '100', '100'),
    ('add', '300', '100', '100', '100'),
    ('add', '300', '0', '200', '100'),
    ('add', '400', '100', '200', '100'),
    # Paul
    ('bas-salaire', 'Paul'),
    ('loyer', 'Paul'),
    ('enfants', 'Paul'),
    ('long-trajet', 'Paul'),
    # Marc
    ('moyen-salaire', 'Marc'),
    ('loyer', 'Marc'),
    ('enfants', 'Marc'),
    ('long-trajet', 'Marc'),
    # Jean
    ('haut-salaire', 'Jean'),
    ('pas-de-loyer', 'Jean'),
    ('pas-d-enfants', 'Jean'),
    ('long-trajet', 'Jean'),
]

regles = [
    # Reduction enfants
    [[('pas-d-enfants', '?x')], ('réduc-enfant', '0', '?x')],
    [[('enfants', '?x')], ('réduc-enfant', '100', '?x')],
    # Reduction loyer
    [[('bas-salaire', '?x'), ('loyer', '?x')], ('réduc-loyer', '200', '?x')],
    [[('moyen-salaire', '?x'), ('loyer', '?x')], ('réduc-loyer', '100', '?x')],
    [[('haut-salaire', '?x'), ('loyer', '?x')], ('réduc-loyer', '0', '?x')],
    [[('pas-de-loyer', '?x')], ('réduc-loyer', '0', '?x')],
    # Reduction transport
    [[('petit-trajet', '?x')], ('réduc-trajet', '0', '?x')],
    [[('réduc-enfant', '0', '?x'), ('long-trajet', '?x')],
     ('réduc-trajet', '100', '?x')],
    [[('réduc-loyer', '0', '?x'), ('long-trajet', '?x')],
     ('réduc-trajet', '100', '?x')],
    [[('réduc-enfant', '100', '?x'), ('réduc-loyer', '100', '?x'),
      ('long-trajet', '?x')], ('réduc-trajet', '50', '?x')],
    [[('réduc-enfant', '100', '?x'), ('réduc-loyer', '200', '?x'),
      ('long-trajet', '?x')], ('réduc-trajet', '0', '?x')],
    # Reduction totale
    [[('réduc-enfant', '?a', '?x'), ('réduc-loyer', '?b', '?x'),
      ('réduc-trajet', '?c', '?x'), ('add', '?res', '?a', '?b', '?c')],
     ('réduc', '?res', '?x')],
]

if len(argv) < 2 or argv[1].lower() not in ('filtre', 'unificateur'):
    print('On attend un argument: Filtre ou Unificateur')
    exit(1)

if argv[1].lower() == 'filtre':
    methode = Filtre()
elif argv[1].lower() == 'unificateur':
    methode = Unificateur()

bc = BaseConnaissances(lambda descr: RegleAvecVariables(descr[0], descr[1]))
bc.ajoute_faits(faits_initiaux)
bc.ajoute_regles(regles)

moteur = ChainageAvantAvecVariables(connaissances=bc, methode=methode)
moteur.chaine()

moteur.affiche_solutions()

if len(argv) > 2 and argv[2].lower() == 'trace':
    moteur.affiche_trace()