__author__ = 'clement'


class Noeud:
    """ Representation d'un noeud (un cluster) dans un dendogramme (une hierarchie de clusters construite\ 
        par le clustering hierarchique)"""
    
    def __init__(self, val, gauche=None, droite=None):
        """
            :param val: la valeur du noeud (None si le noeud n'est pas terminal/feuille)
            :param gauche: le noeud a gauche de ce noeud
            :param droite: le noeud a droite de ce noeud
        """
        self.val = val
        self.gauche = gauche
        self.droite = droite

    def fusion(self, noeud):
        """ Fusionne deux noeuds

            Le nouvel noeud contiendra le noeud courant a gauche et le noeud 'noeud' a droite
            
            :param noeud: un noeud qui ira a droite de la nouvelle racine
            :return: la nouvelle racine
        """
        return Noeud(None, self, noeud)

    def valeurs(self):
        """ Retourne la liste des valeurs contenues dans l'arbre duquel le noeud courant est la racine
        """
        valeurs = []
        if self.val is not None:
            valeurs.append(self.val)

        if self.gauche is not None:
            valeurs += self.gauche.valeurs()

        if self.droite is not None:
            valeurs += self.droite.valeurs()

        return valeurs

    def est_feuille(self):
        """ Retourne True si ce noeud est une feuille (n'a pas de noeuds ni a gauche ni a droite)
        """
        return self.gauche is None and self.droite is None

    def repr_arbre(self, level=0):
        """ Representation de l'arbre duquel le noeud courant est la racine
        """
        if self.val is None:
            rep = '\t'*level + '|' + '-'*8 + '\n'
        else:
            rep = '\t'*(level-1) + '|' + '-'*8 + self.__repr__() + '\n'

        if self.gauche is not None:
            rep += self.gauche.repr_arbre(level+1)
        if self.droite is not None:
            rep += self.droite.repr_arbre(level+1)

        return rep

    def __repr__(self):
        """ Representation du noeud courant
        """
        return self.val.__repr__()
