__author__ = 'clement'

from sys import exit
from copy import deepcopy

from kmeans import KMeansClustering
from hierarchique import ClusteringHierarchique

def distance(x, y):
    """ Calcule la distance entre deux elements en comptant leur nombre d'attributs non identiques.

        :param x: une liste d'attributs
        :param y: une liste d'attributs de la meme longueur que x
    """
    assert (len(y) == len(x))
    return sum([1 for i in range(0, len(x)) if x[i] != y[i]])


if __name__ == '__main__':
    try:
        from samples import entreprises, maladies
    except ImportError as e:
        print(e)
        exit()

    kmeans = KMeansClustering(maladies, 4, distance)
    kmeans.clustering()

    print('Resultat du kmeans clustering:')
    print(kmeans)

    hierarchie = ClusteringHierarchique(maladies, distance)
    hierarchie.clustering()

    print('Resultat du clustering hierarchique:')
    print(hierarchie)
