
class Clustering:
    """ 
        Classe générique pour le clustering. 
        
        Devra être sous-classée selon le type de\
        clustering.        
    """

    def __init__(self):
        self.clusters = []

    def initialise_clusters(self, donnees):
        """ Initialise les clusters (à implémenter différemment pour le\
            clustering k-means et le clustering hiérarchique). 

            :param list donnees: les données à regrouper dans des clusters.
        """

        return []

    def revise_clusters(self):
        """ Révise les clusters (à implémenter différemment pour le clustering\
            k-means et le clustering hiérarchique).
        """

        return []

    def fini(self, anciens_clusters):
        """ Teste si les clusters ont changé par rapport aux anciens clusters
            (à implémenter différemment pour le clustering k-means\
            et le clustering hiérarchique).

            :param list anciens_clusters: la liste des anciens clusters.
        """

        return False

    def itere(self, donnees):
        """ Regroupe les données dans des clusters de façon itérative.

            :param list donnees: les données à regrouper dans des clusters.
        """

        # Sauvegarde des clusters.
        anciens_clusters = []
        self.initialise_clusters(donnees)

        # Continue le clustering tant que les nouveaux clusters ont changé par
        # rapport à l'itération précédente.
        while not self.fini(anciens_clusters):
            anciens_clusters = self.clusters[:]
            self.revise_clusters()