from .cluster import Cluster

class ClusterHierarchique(Cluster):
    """ Représentation d'un cluster utilisé dans l'algorithme de\
        clustering hiérarchique.
    """

    def __init__(self, donnees, gauche=None, droite=None):
        """
            :param list donnees: les données du cluster.
            :param ClusterHierarchique gauche: le sous-cluster de gauche.
            :param ClusterHierarchique droite: le sous-cluster de droite.
        """

        Cluster.__init__(self, donnees)
        self.gauche = gauche
        self.droite = droite

    def est_terminal(self):
        """ Teste si le cluster courant est terminal (c'est-à-dire s'il\
            n'a pas de sous-clusters ni à gauche ni à droite). 
        
            :return: ``True`` quand le cluster courant est terminal.
        """

        return self.gauche is None and self.droite is None

    def repr_hierarchie(self, level=0):
        """ Représentation sous forme de string de la hiérarchie\
            de laquelle le cluster courant est la racine. 
        """

        if self.est_terminal():
            rep = '    '*(level-1) + '|---' + str(self.donnees[0]) + '\n'
        else:
            rep = '    '*level + '|---' + '\n'

        if self.gauche is not None:
            rep += self.gauche.repr_hierarchie(level+1)
        if self.droite is not None:
            rep += self.droite.repr_hierarchie(level+1)

        return rep

    def __repr__(self):
        """ Représentation du cluster sous forme de string. """

        return 'Cluster racine: \n{}'.format(self.repr_hierarchie(level=0))