from .cluster_mean import ClusterMean
from .clustering import Clustering

class ClusteringKMeans(Clustering):
    """ K-means clustering. """

    def __init__(self, k, dist_f):
        """
            :param k: le nombre de clusters à construire.
            :param dist_f: la fonction de distance entre deux données.
        """

        super().__init__()
        self.k = k
        self.dist_f = dist_f

    def noyaux(self, clusters):
        """ Extrait les noyaux d'une liste de clusters. 

           :param list clusters: une liste de clusters dont les noyaux doivent\
           être retournés.
           :return: la liste des noyaux des clusters.
        """

        return [cluster.noyau for cluster in clusters]

    def initialise_clusters(self, donnees):
        """ Initialise les clusters. 

            :param list donnees: les données à regrouper dans des clusters.
        """

        print('à compléter')

    def fini(self, anciens_clusters):
        """ Teste si les clusters ont changé par rapport aux anciens clusters.

            C'est le cas si les noyaux ont changé depuis l'itération précédente.

            :param list anciens_clusters: la liste des anciens clusters.
        """

        print('à compléter')

    def revise_clusters(self):
        """ Révise les clusters. """

        print('à compléter')

    def affiche_clusters(self):
        """ Affiche les clusters construits par l'algorithme."""

        print('\n'.join([str(cluster) for cluster in self.clusters]))