from .cluster_hierarchique import ClusterHierarchique
from .clustering import Clustering

class ClusteringHierarchique(Clustering):
    """ Clustering hiérarchique. """

    liens = {
        'single': min,
        'complete': max,
    }

    def __init__(self, type_lien, dist_f):
        """
            :param str lien: le type de distance entre deux clusters,\
            'single' ou 'complete'.
            :param dist_f: la fonction de distance entre deux données.
        """

        super().__init__()
        self.dist_f = dist_f
        # Permet d'utiliser min ou max de manière générique en fonction du
        # paramètre type_lien.
        self.lien = self.liens[type_lien]

    def fusionne_clusters(self, cluster1, cluster2):
        """ Fusionne deux clusters.

            Le nouveau cluster contiendra ``cluster1`` à gauche et ``cluster2``\
            à droite.
            
            :param cluster1: un noeud qui ira à droite du nouveau cluster.
            :param cluster2: un noeud qui ira à gauche du nouveau cluster.
            :return: le nouveau cluster.
        """
        
        donnees = cluster1.donnees + cluster2.donnees
        return ClusterHierarchique(donnees, cluster1, cluster2)
    
    def calcule_distance(self, cluster1, cluster2):
        """ Calcule la distance entre deux clusters. """

        print('à compléter')

    def initialise_clusters(self, donnees):
        """ Initialise les clusters. 

            :param list donnees: les données à regrouper dans des clusters.
        """

        print('à compléter')

    def fini(self, anciens_clusters):
        """ Teste si les clusters ont changé par rapport aux anciens clusters.

            C'est le cas si leur nombre a diminué.

            :param list anciens_clusters: la liste des anciens clusters.
        """

        print('à compléter')

    def revise_clusters(self):
        """ Révise les clusters. """

        print('à compléter')

    def affiche_clusters(self):
        """ Affiche les clusters découverts par l'algorithme."""

        print('\n'.join([str(cluster) for cluster in self.clusters]))