from .cluster import Cluster

class ClusterMean(Cluster):
    """ Représentation d'un cluster utilisé dans l'algorithme du\
        k-means.
    """

    def __init__(self, donnees, nom):
        """ Initialise le cluster avec un nom et une liste de données.

            :param list donnees: les données du cluster.
            :param str nom: le nom du cluster.
        """

        Cluster.__init__(self, donnees, nom)
        self.noyau = self.donnees[0] if len(self.donnees) > 0 else None

    def centre(self, dist_f):
        """ Recentre le noyau du cluster en fonction des données qu'il contient.

            :param dist_f: la fonction de distance entre deux données.
        """

        print('à compléter')

    def vide(self, garde_noyau=False):
        """ Vide la liste des données du cluster avec l'option de garder le\
            noyau. 
        """ 

        if garde_noyau:
            self.donnees = [self.noyau]
        else:
            self.donnees = []
            self.noyau = None

    def __repr__(self):
        """ Représentation d'un cluster sous forme de string. """

        rep = 'Cluster {}: \n'.format(self.nom)
        for donnee in self.donnees:
            indent = '--->' if donnee == self.noyau else ' '*4
            rep += '{}{}\n'.format(indent, donnee)
        return rep