
class Cluster:
    """ Représentation d'un cluster générique. """

    def __init__(self, donnees, nom=''):
        """ Initialise un cluster avec un nom et une liste de données.

            :param list donnees: les données du cluster.
            :param str nom: le nom du cluster.
        """

        self.donnees = []
        self.ajoute_donnees(donnees)
        self.nom = nom

    def ajoute_donnee(self, donnee):
        """ Ajoute une donnée au cluster. 
            
            :param donnee: la donnée à ajouter.
        """

        self.donnees.append(donnee)

    def ajoute_donnees(self, donnees):
        """ Ajoute une liste de données au cluster. 

            :param list donnees: les données à ajouter.
        """

        for donnee in donnees:
            self.ajoute_donnee(donnee)