/**************************************************************/
/*                                                            */
/*                       Classe TASK                          */
/*                                                            */
/**************************************************************/


package utils; 

import java.util.*;


/**
* Classe Task :
* Tache faisant partie d'un ensemble de taches a accomplir avec
* un nombre de ressources limite. 
*
* @version 1.0, 1 May 1997
* @author Bruno Sakoto
**/

public class Task
{
	
	protected int beginTime;     
	protected int endTime;
	protected int line;          // Numero de la ligne sur laquelle la tache est placee.
	protected int tResource[];   // Ressources possibles pour la tache. L'index i du tableau vaut 
	                             // 0 ou 1 selon que la ressource i peut etre utilisee ou pas.
//	protected int tLabel [];     // Label contenant les resources encore disponibles pour la tache.
//	                             // 0 la ressource n'a jamais ete envisagee, -1 la ressource n'
	                             // est plus envisageable, 1 la ressource est toujours possible.
	protected int resAlocated;   // Le numero de la ressource qui a ete allouee.
	
	
	
	/**************************************************************/
	/* Methode TASK                                               */
	/**************************************************************/

	public Task()
	{
		beginTime = -1;
		endTime = -1;
		line = -1;
		tResource = new int[Work.NB_RESOURCES];
		resAlocated = -1;
	}
	


	
	/**************************************************************/
	/* Methode GET_BEGIN_TIME                                     */
	/**************************************************************/
	/*
	* Permet d'obtenir le temps de debut de la tache.
	*/

	public int GetBeginTime() 
	{
   	return this.beginTime;
  	}
  	
  	
  	
  	
	/**************************************************************/
	/* Methode GET_END_TIME                                       */
	/**************************************************************/
	/*
	* Permet d'obtenir le temps de fin de la tache.
	*/

	public int GetEndTime() 
	{
   	return this.endTime;
  	}  
  	
  	
  	
  	
	/**************************************************************/
	/* Methode GET_LINE                                           */
	/**************************************************************/
	/*
	* Permet d'obtenir la ligne de la tache.
	*/

	public int GetLine() 
	{
   	return this.line;
  	}  




	/**************************************************************/
	/* Methode GET_RESOURCES                                      */
	/**************************************************************/
	/*
	* Permet d'obtenir les ressources de la tache.
	*/
	
	public int[] GetResources() 
	{
   	return this.tResource;
  	}
	
	
	
	/**************************************************************/
	/* Methode SET_RESOURCE_AT                                    */
	/**************************************************************/
	/*
	* Permet de fixer la valeur d'une des ressources de la tache.
	*/
	
	public void SetResourceAt( int val, int ind ) 
	{
   	tResource[ind] = val;
  	}

	
	
	
	/**************************************************************/
	/* Methode GET_ALOCATED_RESOURCE                              */
	/**************************************************************/
	/*
	* Permet d'obtenir la ressource allouee pour la tache.
	*/
	
	public int GetAlocatedResource() 
	{
   	return this.resAlocated;
  	}
	
	
	
	
	/**************************************************************/
	/* Methode SET_ALLOCATED_RESOURCE                             */
	/**************************************************************/
	/*
	* Permet de fixer la ressource allouee pour la tache.
	*/
	
	public void SetAlocatedResource( int r ) 
	{
   	this.resAlocated = r;
  	}
  	



	/**************************************************************/
	/* Methode PRINT                                              */
	/**************************************************************/
	/*
	* Affiche la tache.
	*/
	
	public void Print()
	{
		System.out.print( "Task -> " );
		System.out.print( "line=" + line + "\tt0=" + beginTime + "\tt1=" + endTime );
		
		System.out.print( "\tresources : " );
		for ( int i=0; i<tResource.length; i++ )
			System.out.print( tResource[i] + " ");
							
		System.out.println( "\tAllocated=" + resAlocated );
	
	}
	
	

}
