/**************************************************************/
/*                                                            */
/*                     Classe MY_RANDOM                       */
/*                                                            */
/**************************************************************/


package utils; 

import java.util.*;


/**
* Classe MyRandom :
* Generateur de nombre aleatoitres.
*
* @version 1.0, 1 May 1997
* @author Bruno Sakoto
**/

public class MyRandom extends Random
{     
	
	
	
	/**************************************************************/
	/* Methode MY_RANDOM                                          */
	/**************************************************************/
	
	public MyRandom()
	{
		super();
	}
	
	
	
	
	/**************************************************************/
	/* Methode MY_RANDOM                                          */
	/**************************************************************/
	
	public MyRandom( long seed )
	{
		super( seed );
	}




	/**************************************************************/
	/* Methode NEXT_INT_BETWEEN                                   */
	/**************************************************************/
	/*
	* Delivre l'entier aleatoir suivant compris entre borneInf (incluse)
	* et borneSup (non comprise?).
	* Declenche une exception si borneInf > borneSup.
	*/
	
	public int nextIntBetween( int borneInf, int borneSup ) throws MyRandomException
	{
		if ( borneInf > borneSup )
			throw new MyRandomException( "invalid range" );
			 
		return (int)( Math.floor( super.nextDouble() * (borneSup-borneInf) ) + borneInf );
	}


}
