/**************************************************************/
/*                                                            */
/*                     Classe TASKS_CANVAS                    */
/*                                                            */
/**************************************************************/


package graphics;

import utils.*;
import java.awt.*;
import java.util.*;


/**
* Classe TasksCanvas :
* Canvas pour la representation graphique des taches.
* Utilisee pour l'exercice de satisfaction de contraintes.
*
* @version 	1.0, 1 May 1997
* @author Bruno Sakoto
**/

public class TasksCanvas extends Canvas
{

	// Definition des couleurs utilisees	
	protected static final Color COLOR_BG = Color.white;
	protected static final Color COLOR_BORDER = Color.black;
	protected static final Color COLOR_FONT = Color.black;
	protected static final Color COLOR_TASK = Color.blue;
	
	protected static final Color[] T_RES_COLOR = { Color.pink, Color.cyan, Color.green,
	                                               Color.red, Color.magenta, Color.orange };


	// Definition de la hauteur des lignes
	protected static final int H_LINE = 30;
	
	// Definition du decalage pour en abcisse et ordonnee pour dessiner les taches
	protected static final int DX = 0;
	protected static final int DY = 30;

	// Definition des polices
	protected static final Font FONT_NORMAL = new Font( "Courier", Font.PLAIN, 12 );
	protected static final Font FONT_BOLD = new Font( "Courier", Font.BOLD, 12 );
	protected static final Font FONT_ITALIC = new Font( "Courier", Font.ITALIC, 12 );
	
                            



	/**************************************************************/
	/* Methode TASKS_CANVAS                                       */
	/**************************************************************/
		
	public TasksCanvas()
	{
	}




	/**************************************************************/
	/* Methode PAINT                                              */
	/**************************************************************/
	/**
	* Dessinne le diagramme des taches.
	**/
	
	public void paint( Graphics g )
	{		
		Vector vTask = CSP_Applet.work.GetTasks();		


		// Colorier le fond et tracer le cadre.
		g.setColor( COLOR_BG );
		g.fillRect( 0, 0, getSize().width-1, getSize().height-1 );
		g.setColor( COLOR_BORDER );
		g.drawRect( 0, 0, getSize().width-1, getSize().height-1 );
		
		
		// Placer une legende.
		
		for ( int i=0; i<Work.NB_RESOURCES; i++ )
		{
			g.setColor( T_RES_COLOR[i] );
			g.fillOval( 35+70*i, getSize().height-30, 15, 15 );
			
			g.setColor( COLOR_FONT );
			g.drawString( Work.T_RES_NAME[i] + " :", 15+70*i, getSize().height-18 );
		} 
		
		// Dessiner les taches.
		
		for ( int i=0; i<vTask.size(); i++ )		

		{ 
			Task tache = (Task)vTask.elementAt( i );
			
			if ( tache.GetAlocatedResource() != -1 )
			{
				g.setColor( T_RES_COLOR[tache.GetAlocatedResource()] );
				g.fillRect( DX+tache.GetBeginTime(), DY+(DY+H_LINE)*tache.GetLine(),
			   	         tache.GetEndTime()-tache.GetBeginTime(), H_LINE );
			}

			g.setColor( COLOR_BORDER );
			g.drawRect( DX+tache.GetBeginTime(), DY+(DY+H_LINE)*tache.GetLine(),
			            tache.GetEndTime()-tache.GetBeginTime(), H_LINE );
			
			// Ecrire le numero de la tache
			g.setColor( COLOR_FONT );
			g.setFont( FONT_ITALIC );
			int middleX = DX+tache.GetBeginTime() + (tache.GetEndTime()-tache.GetBeginTime())/2;
			int underY = DY+(DY+H_LINE)*tache.GetLine() + H_LINE;
			g.drawString( "Task" + i, middleX-18, underY+12 ); 
       
			DrawLabel( g, tache );            
			   
			
		}


/*
int beginTime = 50;
int endTime = beginTime + 45;  // + Work.DUREE_MIN
int line = 2;
			
g.drawRect( DX+beginTime, DY+(DY+H_LINE)*line,
            endTime-beginTime, H_LINE );

g.setColor( COLOR_FONT );
g.setFont( FONT_NORMAL );				
g.drawString( "012345", DX+beginTime+2, DY+(DY+H_LINE)*line+20 );
g.setFont( FONT_BOLD );
g.drawString( "  \\ \\", DX+beginTime+2, DY+(DY+H_LINE)*line+20 );
g.drawString( "0   4", DX+beginTime+2, DY+(DY+H_LINE)*line+40 );
*/	
	}
	
	
	
	
	/**************************************************************/
	/* Methode DRAW LABEL                                         */
	/**************************************************************/
	/**
	* Affiche le label d'une tache.
	**/
	
	public void DrawLabel( Graphics g, Task tache )
	{
		// Sauvegarder la couleur et la fonte courante
		Color oldColor = g.getColor();
		Font oldFont = g.getFont();
		
		StringBuffer str1 = new StringBuffer();    // Pour afficher toutes les ressources
		StringBuffer str2 = new StringBuffer();    // Pour eliminer barrer certaines ressources

		StringBuffer str3 = new StringBuffer();    // Pour souligner la ressource choisie

		int tRes[] = tache.GetResources();

		for ( int i=0; i<Work.NB_RESOURCES; i++ )
		{			 
			switch ( tRes[i] )
			{ 
				case 0 :
//					str1.append( " " ); 
//					str2.append( " " );
					break;
				case -1 :
					str1.append( Work.T_RES_NAME[i] );
					str2.append( "\\" );
					if ( i < tache.GetAlocatedResource() )
						str3.append( " " );
					break;
				case 1 :
					str1.append( Work.T_RES_NAME[i] );
					str2.append( " " );
					if ( i < tache.GetAlocatedResource() )
						str3.append( " " );
					
					break;
			}
			
		}
		
		if ( tache.GetAlocatedResource() != -1 )
		{
//			for ( int i=0; i<tache.GetAlocatedResource(); i++ )
//				str3.append( " " );
			str3.append( "_" );
		} 
	
		g.setColor( COLOR_FONT );	
		g.setFont( FONT_NORMAL );			
		g.drawString( str1.toString(), DX+tache.GetBeginTime()+2, DY+(DY+H_LINE)*tache.GetLine()+20 );
		g.setFont( FONT_BOLD );			
		g.drawString( str2.toString(), DX+tache.GetBeginTime()+2, DY+(DY+H_LINE)*tache.GetLine()+20 );
		g.drawString( str3.toString(), DX+tache.GetBeginTime()+2, DY+(DY+H_LINE)*tache.GetLine()+20 );
	
		// Retablir la couleur et la fonte courante
		g.setColor( oldColor );
		g.setFont( oldFont );
		
	}
	
}
