/**************************************************************/
/*                                                            */
/*                    Classe INIT_DIALOG                      */
/*                                                            */
/**************************************************************/


package graphics;

import java.awt.*;


/**
* Classe InitWindow :
* Permet de realiser une fenetre pour demander a l'utilisateur
* de patienter pendant l'initialisation du probleme a resoudre.
*
* @version 	1.0, 1 May 1997
* @author Bruno Sakoto
**/

public class InitWindow extends Frame
{


	/**************************************************************/
	/* Methode INIT_WINDOW                                        */
	/**************************************************************/
	/**
	* Cree une fenetre contenant le message d'attente.
	* @param caller le composant qui appelle la fenetre.
	**/

	public InitWindow( Component caller )
	{
		super( "Message" );
		
		// Fixer le Layout.
		GridBagLayout gridbag = new GridBagLayout();		
		setLayout( gridbag );

		// Placer les labels		
		Constrain.constrain( this, new Label( "Initialisation of the problem !" ), 0, 0, 1, 1,
		                     GridBagConstraints.NONE, GridBagConstraints.CENTER, 
		                     0.0, 0.0, 0, 0, 0, 0 );	
		Constrain.constrain( this, new Label( "Please wait ..." ), 0, 1, 1, 1,
		                     GridBagConstraints.NONE, GridBagConstraints.CENTER, 
		                     0.0, 0.0, 20, 0, 20, 0 );	

		// Dimentionner et placer la fenetre
		setLocation( 500, 150 );
		pack();
		setSize( getSize().width+60, getSize().height+60 );
		setResizable( false );

		// Afficher la fenetre
		setVisible(true);
	}
	
}