/**************************************************************/
/*                                                            */
/*                    Classe INFO_PANEL                       */
/*                                                            */
/**************************************************************/


package graphics;

import java.awt.*;


/**
* Classe InfoPanel :
* Permet de realiser le panneau d'information.
* Utilisee pour l'exercice de satisfactions de contraintes.
*
* @version 1.0, 1 May 1997
* @author Bruno Sakoto
**/

public class InfoPanel extends Panel
{
	protected TextArea detailsTextArea;

	


	/**************************************************************/
	/* Methode INFO_PANEL                                         */
	/**************************************************************/
	/**
	* Construit un panneau d'information.
	**/

	public InfoPanel()
	{
		// Fixer le Layout.
		GridBagLayout gridbag = new GridBagLayout();		
		setLayout( gridbag );

		// Details de la recherche.
		Constrain.constrain( this, new Label( "Solving details :" ), 0, 0, 1, 1,
		                     15, 0, 0, 0 );
		detailsTextArea = new TextArea( 6, 90 );
		detailsTextArea.setFont( new Font( "Courrier", Font.PLAIN, 14 ) );
		detailsTextArea.setEditable( false );
		Constrain.constrain( this, detailsTextArea, 0, 1, 1, 1 );
		

	}
	



	/**************************************************************/
	/* Methode ACTION                                             */
	/**************************************************************/
	/**
	* Apellee si une action intervient dans le paneau de controle.
	**/
	
	public boolean action( Event evt, Object arg )
	{

	
		return false;	
	}




	/**************************************************************/
	/* Methode INIT_DETAILS                                       */
	/**************************************************************/
	/**
	* Initialise la zone de details de la recherche avec une chaine
	* vide.
	**/
	
	public void InitDetails()
	{
		detailsTextArea.setText( "" );
	}



	/**************************************************************/
	/* Methode SET_DETAILS                                        */
	/**************************************************************/
	/**
	* Place une chaine dans la zone de details.
	* @param str la chaine a placer.
	**/
	
	public void SetDetails( String str )
	{
		detailsTextArea.setText( str );
		detailsTextArea.append( "\n" );
	}




	/**************************************************************/
	/* Methode APPEND_DETAILS                                     */
	/**************************************************************/
	/**
	* Ajoute une chaine dans la zone de details.
	* @param str la chaine a placer.
	**/
	
	public void AppendDetails( String str )
	{
		detailsTextArea.append( str );
		detailsTextArea.append( "\n" );
	}

	
}
