/**************************************************************/
/*                                                            */
/*                   Classe CONTROL_PANEL                     */
/*                                                            */
/**************************************************************/


package graphics;

import utils.*;
import java.awt.*;
import java.awt.event.*;


/**
* Classe ControlPanel :
* Permet de realiser le panneau de controle.
* Utilisee pour l'exercice de satisfaction de contraintes.
*
* @version 1.0, 1 May 1997
* @author Bruno Sakoto
**/

public class ControlPanel extends Panel implements ActionListener
{

	protected Button generateButton;
	protected Choice algoChoice;
	protected Checkbox stepCheckbox;
	protected Button solveButton;
	protected Button nextButton;
	protected Button finishButton;
	protected Button abortButton;
	
	protected boolean waitFlag; 
	
	
	
	/**************************************************************/
	/* Methode CONTROL_PANEL                                      */
	/**************************************************************/
	/**
	* Construit un panneau de controle avec ses differents composants.
	**/
	
	public ControlPanel()
	{
		// Fixer le Layout.
		GridBagLayout gridbag = new GridBagLayout();		
		setLayout( gridbag );
		
		// Bouton de generation des taches.
		generateButton = new Button( "Generate problem" );
		Constrain.constrain( this, generateButton, 0, 0, 2, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 30, 15, 15, 15 );
		generateButton.addActionListener(this);


		// Choix de l'algorithme de recherche.
		Constrain.constrain( this, new Label( "Method :" ), 0, 1, 1, 1, 15, 15, 0, 0 );
		algoChoice = new Choice();
		for ( int i=0; i<Work.T_ALGO.length; i++ )
			algoChoice.addItem( Work.T_ALGO[i] );
		Constrain.constrain( this, algoChoice, 1, 1, 1, 1, 15, 15, 0, 15 );


		// Choix de l'option pas a pas.
		stepCheckbox = new Checkbox( "Step by step solving" );
		stepCheckbox.setState( true );
		Constrain.constrain( this, stepCheckbox, 0, 2, 2, 1, 15, 15, 0, 15 ); 

		

		// Bouton de lancement de la recherche.
		solveButton = new Button( "Solve problem" );
		Constrain.constrain( this, solveButton, 0, 3, 2, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 30, 15, 15, 15 );
		solveButton.addActionListener(this);


		// Bouton de consultation de l'etape suivante.
		nextButton = new Button( "Next step" );
		Constrain.constrain( this, nextButton, 0, 4, 1, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 30, 15, 15, 0 );
		nextButton.addActionListener(this);


		// Bouton de terminaison de la resolusion.
		finishButton = new Button( "Go" );
		Constrain.constrain( this, finishButton, 1, 4, 1, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 30, 60, 15, 15 );
		finishButton.addActionListener(this);

		// Bouton d'abandon de la resolusion.
		abortButton = new Button( "Abort" );
		Constrain.constrain( this, abortButton, 1, 5, 1, 1, GridBagConstraints.BOTH, 
		                     GridBagConstraints.CENTER, 0.0, 0.0, 30, 60, 15, 15 );
		abortButton.addActionListener(this);

		// Se placer dans l'etat 0
		IntoState( 0 );

		
	}
	
	
	
	

	/**************************************************************/
	/* Methode GET_GENERATE_BUTTON                                */
	/**************************************************************/
	/*
	* Permet d'obtenir le bouton generate du panneau de controle.
	*/

	public Button GetGenerateButton()
	{
		return this.generateButton;
	}





	/**************************************************************/
	/* Methode GET_STEP_CHECKBOX                                  */
	/**************************************************************/
	/*
	* Permet d'obtenir la checkbox de resolution pas a pas.
	*/

	public Checkbox GetStepCheckbox()
	{
		return this.stepCheckbox;
	}





	/**************************************************************/
	/* Methode GET_SOLVE_BUTTON                                   */
	/**************************************************************/
	/*
	* Permet d'obtenir le bouton solve du panneau de controle.
	*/

	public Button GetSolveButton()
	{
		return this.solveButton;
	}




	/**************************************************************/
	/* Methode GET_NEXT_BUTTON                                    */
	/**************************************************************/
	/*
	* Permet d'obtenir le bouton next du panneau de controle.
	*/

	public Button GetNextButton()
	{
		return this.nextButton;
	}



	/**************************************************************/
	/* Methode GET_FINISH_BUTTON                                  */
	/**************************************************************/
	/*
	* Permet d'obtenir le bouton finish du panneau de controle.
	*/

	public Button GetFinishButton()
	{
		return this.finishButton;
	}





	/**************************************************************/
	/* Methode GET_ALGO_CHOICE                                    */
	/**************************************************************/
	/*
	* Permet d'obtenir le choix d'algorithme du panneau de controle.
	*/

	public Choice GetAlgoChoice()
	{
		return this.algoChoice;
	}






	/**************************************************************/
	/* Methode GET_WAIT_FLAG                                      */
	/**************************************************************/
	/*
	* Permet d'obtenir la valeur du booleen d'attente du panneau de controle.
	*/

	public boolean GetWaitFlag()
	{
		return this.waitFlag;
	}






	/**************************************************************/
	/* Methode INTO_STATE                                         */
	/**************************************************************/
	/*
	* Place le panneau de controle dans un etat specifique.
	* @param state l'etat dans lequel on veut mettre le panneau de
	* controle.
	*/

	public void IntoState( int state )
	{
		switch ( state )
		{
			case 0 : // Attente de generation d'un probleme.
				
				generateButton.setEnabled(true);
				algoChoice.setEnabled(false);
				stepCheckbox.setEnabled(false);
				solveButton.setEnabled(false);
				nextButton.setEnabled(false);
				finishButton.setEnabled(false);
				abortButton.setEnabled(false);
				
				break;
				
			case 1 : // Attente de resolution d'un probleme.
				
				generateButton.setEnabled(true);
				algoChoice.setEnabled(true);
				stepCheckbox.setEnabled(true);
				solveButton.setEnabled(true);
				nextButton.setEnabled(false);
				finishButton.setEnabled(false);
				abortButton.setEnabled(false);
				
				break;	
						
			case 2 : // Resolution en cours (sans Step by step)
				
				generateButton.setEnabled(false);
				algoChoice.setEnabled(false);
				stepCheckbox.setEnabled(false);
				solveButton.setEnabled(false);
				nextButton.setEnabled(false);
				finishButton.setEnabled(false);
				abortButton.setEnabled(true);
				
				break;
							
			case 3 : // Resolution en cours (avec Step by step actif)
				
				generateButton.setEnabled(false);
				algoChoice.setEnabled(false);
				stepCheckbox.setEnabled(false);
				solveButton.setEnabled(false);
				nextButton.setEnabled(false);
				finishButton.setEnabled(true);
				abortButton.setEnabled(true);
				
				break;
				
			case 4 : // Attente de passage a l'etape suivante.
				
				generateButton.setEnabled(false);
				algoChoice.setEnabled(false);
				stepCheckbox.setEnabled(false);
				solveButton.setEnabled(false);
				nextButton.setEnabled(true);
				finishButton.setEnabled(true);
				abortButton.setEnabled(true);
							
				break;			
		}
	}




	
	/**************************************************************/
	/* Methode ACTION                                             */
	/**************************************************************/
	/**
	* Apellee si une action intervient dans le paneau de controle.
	**/
	
	public void actionPerformed( ActionEvent evt)
	{
		if ( evt.getSource() == generateButton )
		{
			// GENERATE_BUTTON
 
			InitWindow initWin = new InitWindow( (CSP_Applet)this.getParent() );
			try
			{
				CSP_Applet.work.GenerateTasks();
			} catch( MyRandomException e ) {}
			initWin.dispose();
			
			System.out.println( "\nTaches generees : " );
			CSP_Applet.work.PrintTasks();
			
			((CSP_Applet)this.getParent()).dessin.repaint();
			
				

			// Se placer dans l'etat 1

			IntoState( 1 );

			

			// Effacer la zone d'information

			((CSP_Applet)this.getParent()).info.InitDetails();
	

			
		}

	
		if ( evt.getSource() == solveButton )
		{
			// SOLVE_BUTTON
			

			waitFlag = stepCheckbox.getState();

			

			// Se placer dans l'etat 2 ou 3

			if ( waitFlag ) 
	
			IntoState( 3 );	
			
	
		else
	
			IntoState( 2 );

			

			// Lancer la resolution
			CSP_Applet.work.Solve();
			
			((CSP_Applet)this.getParent()).dessin.repaint();

		}
		

		if ( evt.getSource() == nextButton )
		{
			// NEXT_BUTTON

			// Se placer dans l'etat 2
			IntoState( 2 );

			CSP_Applet.work.monitor.Signal();
		}


		if ( evt.getSource() == finishButton )
		{
			// FINISH_BUTTON
					
			if ( waitFlag )
			{
				waitFlag = false;
			
				finishButton.setLabel( "Wait" );
			
				// Se placer dans l'etat 3
				IntoState( 3 );		
				
				CSP_Applet.work.monitor.Signal();	
			}
			else
			{
				waitFlag = true;

				finishButton.setLabel( "Go" );
				
				// Se placer dans l'etat 4
				IntoState( 4 );
			}		
					
			
		}
		

		if ( evt.getSource() == abortButton )
		{
			// ABORT_BUTTON
if ( waitFlag )			
CSP_Applet.work.monitor.Signal();
			// Stopper la resolution
			CSP_Applet.work.GetSolver().StopSolving();
		
			// Signaler l'interruption

			((CSP_Applet)this.getParent()).info.AppendDetails( "\nAborted !" );		
		
			// Se placer dans l'etat 1
			IntoState( 1 );
		}
		
				
	}
	
	
	
	
}