/**************************************************************/
/*                                                            */
/*                      Classe CONSTRAIN                      */
/*                                                            */
/**************************************************************/


package graphics;

import java.awt.*;


/**
* Classe Constrain :
*
* Contient des methodes permettant de placer rapidement des composants
* dans un layout de type GridBagLayout.
*
* @see java.awt.GridBagLayout
* @version 	1.0, 1 Avr 1997
* @author Bruno Sakoto
**/

public class Constrain
{

	/**************************************************************/
	/* Methode CONSTRAIN                                          */
	/**************************************************************/
	/**
	* Methode generale possedant des parametres pour toutes les contraintes.
	**/

	public static void constrain( Container container, Component component, 
	                              int grid_x, int grid_y, int grid_width, int grid_height,
	                              int fill, int anchor, double weight_x, double weight_y,
	                              int top, int left, int bottom, int right )
	{
		GridBagConstraints c = new GridBagConstraints();
		c.gridx = grid_x; c.gridy = grid_y;
		c.gridwidth = grid_width; c.gridheight = grid_height;
		c.fill = fill; c.anchor = anchor;
		c.weightx = weight_x; c.weighty = weight_y;
		if( top + bottom + left + right > 0 )
			c.insets = new Insets( top, left, bottom, right );
			
		((GridBagLayout)container.getLayout()).setConstraints( component, c );
		container.add( component );
	}
			


	
	/**************************************************************/
	/* Methode CONSTRAIN                                          */
	/**************************************************************/
	/**
	* Methode permettant de specifier la position d'un composant qui
	* ne grandit pas et qui n'a pas de marges. 
	**/
	
	public static void constrain( Container container, Component component, 
	                              int grid_x, int grid_y, int grid_width, int grid_height )
	{
		constrain( container, component, grid_x, grid_y, grid_width, grid_height,
		           GridBagConstraints.NONE, GridBagConstraints.WEST, 
		           0.0, 0.0, 0, 0, 0, 0 );
	}
	

	
	
	/**************************************************************/
	/* Methode CONSTRAIN                                          */
	/**************************************************************/
	/**
	* Methode permettant de specifier la position d'un composant qui
	* ne grandit pas mais qui a des marges. 
	**/

	public static void constrain( Container container, Component component, 
	                              int grid_x, int grid_y, int grid_width, int grid_height,
	                              int top, int left, int bottom, int right )
	{
		constrain( container, component, grid_x, grid_y, grid_width, grid_height,
		           GridBagConstraints.NONE, GridBagConstraints.WEST, 
		           0.0, 0.0, top, left, bottom, right );
	}
	
}
