/**************************************************************/
/*                                                            */
/*                     Classe CSP_APPLET                      */
/*                                                            */
/**************************************************************/


package graphics;

import utils.*;
import java.applet.*;
import java.awt.*;


/**
* Classe CSP_Applet :
* Applet pour l'exercice de satisfaction de contraintes.
*
* @version 1.0, 1 May 1997
* @author Bruno Sakoto
**/

public class CSP_Applet extends Applet implements Runnable
{
	protected TasksCanvas dessin;
	protected ControlPanel control;
	protected InfoPanel info;
	
	protected Thread anim = null;
	

	protected static Work work;       // L'espace de travail.
	


	/**************************************************************/
	/* Methode INIT                                               */
	/**************************************************************/
	/**
	* Initialisation de l'applet.
	**/
	
	public void init() 
	{
	
		GridBagLayout gridbag = new GridBagLayout();
		setLayout( gridbag );

		// Mise en place du diagramme des taches.
		dessin = new TasksCanvas();
		Constrain.constrain( this, dessin, 0, 0, 1, 1 );
		dessin.setSize( 600, 400 );  //500x270
		
		// Mise en place du panneau de controle.
		control = new ControlPanel();
		Constrain.constrain( this, control, 1, 0, 1, 1 );

		
		
		// Mise en place du panneau d'information.
		info = new InfoPanel();
		Constrain.constrain( this, info, 0, 1, 2, 1 );

		work = new Work( dessin, control, info );

		
	}



	
	/**************************************************************/
	/* Methode START                                              */
	/**************************************************************/
	/**
	* Demmarrage de l'applet.
	**/

	public void start()
	{
	
		if ( anim == null )
		{
			anim = new Thread( this );
			anim.start();
		}
	}


	
	
	/**************************************************************/
	/* Methode STOP                                              */
	/**************************************************************/
	/**
	* Interruption de l'applet.
	**/

	public void stop()
	{	
		if ( anim != null )
			anim.stop();
		anim = null;
	
	}
	
	
	
	/**************************************************************/
	/* Methode RUN                                                */
	/**************************************************************/
	/**
	* Executee lorsque l'applet demmarre.
	**/

	public void run()
	{
		while ( true )
		{
			try { Thread.sleep( 1000 ); }
			catch ( InterruptedException e ){};
		}
	}
	
	

}
