package JCL; 

import java.util.*;
import utils.*;
 
/**
 * Task Network Builder.
 *
 * @author Marc Torrens
 */

public class TaskNetworkBuilder extends NetworkBuilder {
  
  String name;
  String author;
  int size;
  Vector vTask;
 
  
  /*
   *	Constructor.
   */
  
  public TaskNetworkBuilder (String name, String author, Vector taches ) {
    this.name = new String (name);
    this.author = new String (author);
    this.size = taches.size();
    this.vTask = taches;
 }
  
  public LiteralNetwork Build () {
    LiteralNetwork net = new LiteralNetwork ();
    
    net.SetName (name);
    net.SetAuthor (author);
    
    //	Create a unique domain with 'NB_MAX_RESSOURCES' values
    
    String dname; 
    String vname;

    for (int i = 0; i < size; i++) {
      dname = "Resources" + Integer.toString (i);
      vname = "Task" + Integer.toString (i+1);vname = "Task" + Integer.toString (i);
      
      net.AddDomain (dname);
      for (int j = 0; j < Work.NB_RESOURCES; j++) {
	if (((Task)vTask.elementAt(i)).GetResources()[j] == 1) {
	  net.AddValue (dname, "" + Work.T_RES_NAME[j]);
	}
      }
      
      net.AddVariable (vname);
      net.SetVariableDomain (vname, dname); 
    }
    
    //	Set the constraints
    
    Enumeration d1 = net.GetDomains ();
    int i = 0;
    for (Enumeration e = net.GetVariables (); e.hasMoreElements ();i ++) {
      boolean accept_var = false;
      
      String var1 = (String)(e.nextElement ());
      String dname1 = (String)(d1.nextElement ());
     
      Enumeration d2 = net.GetDomains ();
      int j = 0;
      for (Enumeration f = net.GetVariables (); f.hasMoreElements ();j ++) {
 	String var2 = (String)(f.nextElement ());
	String dname2 = (String)(d2.nextElement ());

 	if (!accept_var) {
 	  if (var1.equals (var2))
 	    accept_var = true;
 	  continue;
 	}	

 	for (Enumeration g = net.GetValues (dname1); g.hasMoreElements ();) {
 	  String val1 = (String)(g.nextElement ());

 	  for (Enumeration h = net.GetValues (dname2); h.hasMoreElements ();) {
 	    String val2 = (String)(h.nextElement ());
	    
 	    //	Consider resource cases
	    
 	    if ((val1.equals (val2)) && (intersectionTime (i, j))) {
 	      //  The same resource is not allowed if the tasks use the same resource and
	      //  the intersection of times is not empty.
 	      continue;
 	    }
 	    //	Set constraint in other cases
 	    net.SetConstraint (var1, var2, val1, val2);
 	  }
 	}
      }
    }
    
    return net;
  }
  
  /*********************************************************/
  /*********** Check if the task are intersected ***********/
  /*********************************************************/
  private boolean intersectionTime (int i, int j) {
    
    boolean result = false;
    
    int beginTime1 = ((Task)vTask.elementAt(i)).GetBeginTime ();
    int beginTime2 = ((Task)vTask.elementAt(j)).GetBeginTime ();
    int endTime1 = ((Task)vTask.elementAt(i)).GetEndTime ();
    int endTime2 = ((Task)vTask.elementAt(j)).GetEndTime ();
    
    if (((beginTime1 <= beginTime2) && (beginTime2 <= endTime1)) 
	|| ((beginTime1 <= endTime2)   && (endTime2 <= endTime1))
	|| ((beginTime2 <= beginTime1) && (beginTime1 <= endTime2)) 
	|| ((beginTime2 <= endTime1)   && (endTime1 <= endTime2))) result = true;
    
    return result;
  }
}
