package JCL;

/**
 * Step by step manager interface for the Java Constraint Library.
 *
 * This interface is used for stepping in algorithms.
 *
 * @author Erik Bruchez
 */

public interface StepByStepManager {
	public void NotifyStart (Network net);
	public void NotifyEnterLevel (int level);
	public void NotifyLeaveLevel (int level);
	public void NotifyLeaveLevelAux( int level );
	public void NotifyBackjump();
	public void NotifyInstanciation (int variable, int value);
	public void NotifyDomainRestriction (int v1, int v2, int domain[], int old_count, int shrink);
	public void NotifyDomainRestoration (int v1, int v2, int domain[], int restore_count);
	public void NotifyConsistencyCheck ();
	public void NotifyEnd ();
}
