package JCL;

import java.util.Hashtable;

/**
 * Representation of a CSP for the Java Constraint Library.
 *
 * This representation is explicit, i.e. the constraints must explicitly
 * be set symmetrically, and each variable must be set consistent with
 * itself.
 *
 * @author Erik Bruchez
 * @version Last Update 15-11-96
 */

public class Network {

	int size = 0;
	String name;
	String author;

	Hashtable hash;

	Variable vr[];
	Constraint cs[][];

	/*
	 *	Constructors.
	 */

	public Network () {
		
	}

	public Network (int size) {
		SetSize (size);
	}

	public Network (String name, String author, int size) {
		SetSize (size);
		SetName (name);
		SetAuthor (author);
	}

	/**
	 *	Set the number of variables.
	 */

	public void SetSize (int size) {
		this.size = size;
		hash = new Hashtable (size);
		vr = new Variable[size];
		cs = new Constraint[size][size];

		for (int i = 0; i < size; i++)
			vr[i] = null;

		for (int i = 0; i < size; i++)
			for (int j = 0; j < size; j++)
				cs[i][j] = null;
	}

	/**
	 *	Set the name of the network.
	 */

	public void SetName (String name) {
		this.name = new String (name);
	}

	/**
	 *	Get the name of the network.
	 */

	public String GetName () {
		return new String (name);
	}

	/**
	 *	Set the author of the network.
	 */

	public void SetAuthor (String author) {
		this.author = new String (author);
	}

	/**
	 *	Get the author of the network.
	 */

	public String GetAuthor () {
		return new String (author);
	}

	/**
	 *	Get the number of variables.
	 */

	public int GetSize () {
		return size;
	}

	/**
	 *	Convert the network into a string.
	 */

	public String toString () {
		//	NIY
		return "";
	}

	/**
	 *	Set a variable according to its index.
	 */

	public void SetVariable (int index, Variable v) {
		String name = v.GetName ();
		
		if (hash.get (name) == null) {

			//	The variable name is not in use in this network

			hash.put (name, new Integer (index));
		} else {
			throw new RuntimeException ("Variable name already used.");	// TMP
		}
		
		vr[index] = v;
	}

	/**
	 *	Get a variable, according to its index.
	 */

	public Variable GetVariable (int index) {
		return vr[index];
	}

	/*
	 *	Set a constraint between two variables, given their indexes.
	 */

	private void SetConstraint (int index1, int index2, Constraint c) {
		cs[index1][index2] = c;
	}

	/**
	 *	Set a constraint between two variables. The constraint knows the
	 *	concerned variables.
	 */

	public void SetConstraint (Constraint c) {

		String name1 = c.GetFirstVariable ().GetName ();
		String name2 = c.GetSecondVariable ().GetName ();

		Integer i1 = (Integer)(hash.get (name1));
		Integer i2 = (Integer)(hash.get (name2));

		if ((i1 == null) || (i2 == null))
			throw (new UndefinedVariableException ());

		int index1 = i1.intValue ();
		int index2 = i2.intValue ();

		SetConstraint (index1, index2, c);
	}

	/**
	 *	Get a the constraint between two variables, given their indexes.
	 */

	public Constraint GetConstraint (int index1, int index2) {
		return cs[index1][index2];
	}

	/**
	 *	Get the constraint between two variables, given their names.
	 */

	public Constraint GetConstraint (String name1, String name2) {
		
		//	TODO : check the names

		int index1 = ((Integer)(hash.get (name1))).intValue ();
		int index2 = ((Integer)(hash.get (name2))).intValue ();

		return GetConstraint (index1, index2);
	}

	/**
	 *	Build a LiteralNetwork from the Network.
	 */

	public LiteralNetwork BuildLiteralNetwork () {

		int i, j, k, l;
		
		//	Create LiteralNetwork

		LiteralNetwork network = new LiteralNetwork ();

		network.SetName (name + " Arc-Con");
		network.SetAuthor (author);

		//	Create the domains with their values and the variables.

		for (i = 0; i < size; i++) {
			network.AddVariable ( this.GetVariable(i).GetName());
			if (!network.CheckDomain ( vr[i].domain.name)) {
			//	The domain doesn't exist.
				network.AddDomain (vr[i].domain.name);
				for (j = 0; j < vr[i].domain.GetSize () ; j++) {
				//	Add the value to the domain
					network.AddValue (vr[i].domain.name, vr[i].domain.GetValueName (j));
				}		
			}
			network.SetVariableDomain (vr[i].name, vr[i].domain.name);
		}

		//	Create the constrains

		network.UnsetAllConstraints ();
		int domain_i;
		int domain_j;

		for (i = 0; i < size; i ++) {
			domain_i = vr[i].domain.GetSize ();
			for (j = 0; j < size; j ++) {

				if (GetConstraint (i, j).IsExplicit ()) {
						
					domain_j = vr[j].domain.GetSize ();
					for (k = 0; k < domain_i; k ++) {
						for (l = 0; l < domain_j; l++) {
							if (GetConstraint (i, j).GetConstraint (k, l)) {
								network.SetConstraint (vr[i].name, vr[j].name, vr[i].domain.GetValueName(k), vr[j].domain.GetValueName(l));
							}
						}
					}
				}
			}
		}


		return network;	
	}
}
