package JCL;

import utils.*; 


/**
 * Default step by step manager.
 *
 * @author Marc Torrens
 */

public class MyStepByStepManager implements StepByStepManager {

  Network net;
  ActionInterface intf;
  String str;
  
  int enters = 0;
  int leaves = 0;
  int insts = 0;
  int checks = 0;
  
  Work work;
  
  
  
  /*
   *	Constructor.
   */
  
  public MyStepByStepManager ( Work wk ) {
  		work = wk;
  }
  
  
  
  
  /**
    *	Notify that a solving is beginning.
    */
  
	public void NotifyStart( Network net )
	{
		this.net = net;

//		String str = new String( "Starting step-by-step" );
//		System.out.println( str );

		// Aditional code :
		work.GetControl().GetFinishButton().setLabel( "Go" );
  }
  
  
  
  
  
  /**
    *	Enter a new recursion level.
    */
  
  public void NotifyEnterLevel (int level){
    enters++;
    
    String str = new String( "Entering level " + Integer.toString (level) );
//    System.out.println( str );
    
   	// Aditional code :
		work.GetInfo().AppendDetails( str );
		  
  }
  
  
  
  
  
  /**
    *	Leave a recursion level.
    */
  
  public void NotifyLeaveLevel (int level) {
    leaves++;
  
		String str = new String( "Leaving level " + Integer.toString (level) );  
//    System.out.println ( str );
    
    	// Aditional code :
   
		work.GetTask( level ).SetAlocatedResource( -1 );
  
  		work.GetDessin().repaint(); 	
		
		work.GetInfo().AppendDetails( str );
		
		if ( work.GetControl().GetWaitFlag() )
		{
			// Placer le panneau de controle dans l'etat 4
			work.GetControl().IntoState( 4 );
			work.monitor.Wait();
		}    
  }
  
  
 
 
 
   /**
    *	Leave a recursion level. Without counting leaves.
    * Using by backjumping algorithms.
    */
  
  public void NotifyLeaveLevelAux (int level) {
  
		String str = new String( "Leaving level " + Integer.toString (level) );  
//    System.out.println ( str );
    
    	// Aditional code :
   
		work.GetTask( level ).SetAlocatedResource( -1 );
  
  		work.GetDessin().repaint(); 	
		
		work.GetInfo().AppendDetails( str );
		
		if ( work.GetControl().GetWaitFlag() )
		{
			// Placer le panneau de controle dans l'etat 4
			work.GetControl().IntoState( 4 );
			work.monitor.Wait();
		}    
  }
   
  
  
  
  /**
  * Count the leaves in backjumping algorithms.
  **/
  
  public void NotifyBackjump()
  {
  		leaves ++;
  } 
  
  
  
  
  /**
    *	Instanciate a variable.
    */
  
  public void NotifyInstanciation (int variable, int value) {
    insts++;
    
    String str = new String( "Instantiating " + net.GetVariable( variable ).GetName()
			+ ", resource " + net.GetVariable( variable ).GetDomain().GetValueName( value ) );
		
 //   System.out.println( str );
	
		// Aditional code :
		String strRes = net.GetVariable(variable).GetDomain().GetValueName(value);
		int indRes = work.IndexOfResource( strRes );
		work.GetTask( variable ).SetAlocatedResource( indRes );

		work.GetDessin().repaint(); 	
		
		work.GetInfo().AppendDetails( str );

		if ( work.GetControl().GetWaitFlag() )
		{
			// Placer le panneau de controle dans l'etat 4
			work.GetControl().IntoState( 4 );
			work.monitor.Wait();
		}
}
 
 
 
  
  /**
    *	Variable v1 causes v2 domain to be restricted. "domain" contains only
    *	-1's, except for values that have been removed from the domain, where 
    *	the number of the responsible variable is kept.
    */
  
  public void NotifyDomainRestriction (int v1, int v2, int domain[],
				       int old_count, int shrink) {
    
    String str = new String ("Variable " + net.GetVariable( v1 ).GetName()
			+ " shrinks variable " + net.GetVariable( v2 ).GetName()
			+ " domain containing " + Integer.toString (old_count)
			+ " values to " + Integer.toString (old_count - shrink)
			+ " values.");	   

//		System.out.println( str );
			
	
		// Aditional code :
		for ( int i=0; i<net.GetVariable(v2).GetDomain().GetSize(); i++ )
		{		
			if ( domain[i] != -1 )
			{
				String strRes = net.GetVariable(v2).GetDomain().GetValueName(i);
				int indRes = work.IndexOfResource( strRes );
				work.GetTask( v2 ).SetResourceAt( -1, indRes  );
			}
		}

		work.GetDessin().repaint(); 	
		
		work.GetInfo().AppendDetails( str );

		if ( work.GetControl().GetWaitFlag() )
		{
			// Placer le panneau de controle dans l'etat 4
			work.GetControl().IntoState( 4 );
			work.monitor.Wait();
		}
  }
  
  
  
  

  /**
    *	The v2 domain restriction caused by variable v1 is restored with
    *	restore_count values.
    */
  
  public void NotifyDomainRestoration (int v1, int v2, int domain[], int restore_count) {
    
    String str = new String( "Variable " + net.GetVariable( v2 ).GetName()
			+ " domain restriction caused by variable " + net.GetVariable( v1 ).GetName()
			+ " is restored with " + Integer.toString (restore_count)
			+ " values.");
			
//		System.out.println( str );
		
		// Aditional code :
		
		for ( int i=0; i<net.GetVariable(v2).GetDomain().GetSize(); i++ )
		{
			if ( domain[i] == -1 )
			{
				String strRes = net.GetVariable(v2).GetDomain().GetValueName(i);
				int indRes = work.IndexOfResource( strRes );
				work.GetTask( v2 ).SetResourceAt( 1, indRes  );
			}
		}

		work.GetDessin().repaint(); 
							
		work.GetInfo().AppendDetails( str );

		if ( work.GetControl().GetWaitFlag() )
		{
			// Placer le panneau de controle dans l'etat 4
			work.GetControl().IntoState( 4 );
			work.monitor.Wait();
		}		
			
  }
  





  /**
    *	Do a consistency check.
    */
  
  public void NotifyConsistencyCheck () {
    checks++;
    //System.out.println ("Checking");
  }
  
  
  
  
  
  /**
    *	Notify that the solving is ending.
    */
  
  public void NotifyEnd () {
//    System.out.println ("Ending step-by-step");

		work.GetInfo().AppendDetails( "\n" );
    work.GetInfo().AppendDetails( "Number of enters         : " + (enters-1) );
    work.GetInfo().AppendDetails( "Number of backtracks     : " + leaves);
    work.GetInfo().AppendDetails( "Number of instantiations : " + insts);
    work.GetInfo().AppendDetails( "Number of checks         : " + checks);

		// Aditional code :
		
		// Placer le panneau de controle dans l'etat 1
		work.GetControl().IntoState( 1 );
   
  } 
}
